/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.command.CommandType;
import com.linecorp.centraldogma.server.command.CreateProjectCommand;
import com.linecorp.centraldogma.server.command.CreateRepositoryCommand;
import com.linecorp.centraldogma.server.command.CreateSessionCommand;
import com.linecorp.centraldogma.server.command.PurgeProjectCommand;
import com.linecorp.centraldogma.server.command.PurgeRepositoryCommand;
import com.linecorp.centraldogma.server.command.PushCommand;
import com.linecorp.centraldogma.server.command.RemoveProjectCommand;
import com.linecorp.centraldogma.server.command.RemoveRepositoryCommand;
import com.linecorp.centraldogma.server.command.RemoveSessionCommand;
import com.linecorp.centraldogma.server.command.UnremoveProjectCommand;
import com.linecorp.centraldogma.server.command.UnremoveRepositoryCommand;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CreateProjectCommand.class, name="CREATE_PROJECT"), @JsonSubTypes.Type(value=RemoveProjectCommand.class, name="REMOVE_PROJECT"), @JsonSubTypes.Type(value=PurgeProjectCommand.class, name="PURGE_PROJECT"), @JsonSubTypes.Type(value=UnremoveProjectCommand.class, name="UNREMOVE_PROJECT"), @JsonSubTypes.Type(value=CreateRepositoryCommand.class, name="CREATE_REPOSITORY"), @JsonSubTypes.Type(value=RemoveRepositoryCommand.class, name="REMOVE_REPOSITORY"), @JsonSubTypes.Type(value=PurgeRepositoryCommand.class, name="PURGE_REPOSITORY"), @JsonSubTypes.Type(value=UnremoveRepositoryCommand.class, name="UNREMOVE_REPOSITORY"), @JsonSubTypes.Type(value=PushCommand.class, name="PUSH"), @JsonSubTypes.Type(value=CreateSessionCommand.class, name="CREATE_SESSIONS"), @JsonSubTypes.Type(value=RemoveSessionCommand.class, name="REMOVE_SESSIONS")})
public interface Command<T> {
    public static Command<Void> createProject(Author author, String name) {
        return Command.createProject(null, author, name);
    }

    public static Command<Void> createProject(@Nullable Long timestamp, Author author, String name) {
        Objects.requireNonNull(author, "author");
        return new CreateProjectCommand(timestamp, author, name);
    }

    public static Command<Void> removeProject(Author author, String name) {
        return Command.removeProject(null, author, name);
    }

    public static Command<Void> removeProject(@Nullable Long timestamp, Author author, String name) {
        Objects.requireNonNull(author, "author");
        return new RemoveProjectCommand(timestamp, author, name);
    }

    public static Command<Void> unremoveProject(Author author, String name) {
        return Command.unremoveProject(null, author, name);
    }

    public static Command<Void> unremoveProject(@Nullable Long timestamp, Author author, String name) {
        Objects.requireNonNull(author, "author");
        return new UnremoveProjectCommand(timestamp, author, name);
    }

    public static Command<Void> purgeProject(Author author, String name) {
        Objects.requireNonNull(author, "author");
        return new PurgeProjectCommand(null, author, name);
    }

    public static Command<Void> purgeProject(@Nullable Long timestamp, Author author, String name) {
        Objects.requireNonNull(author, "author");
        return new PurgeProjectCommand(timestamp, author, name);
    }

    public static Command<Void> createRepository(Author author, String projectName, String repositoryName) {
        return Command.createRepository(null, author, projectName, repositoryName);
    }

    public static Command<Void> createRepository(@Nullable Long timestamp, Author author, String projectName, String repositoryName) {
        Objects.requireNonNull(author, "author");
        return new CreateRepositoryCommand(timestamp, author, projectName, repositoryName);
    }

    public static Command<Void> removeRepository(Author author, String projectName, String repositoryName) {
        return Command.removeRepository(null, author, projectName, repositoryName);
    }

    public static Command<Void> removeRepository(@Nullable Long timestamp, Author author, String projectName, String repositoryName) {
        Objects.requireNonNull(author, "author");
        return new RemoveRepositoryCommand(timestamp, author, projectName, repositoryName);
    }

    public static Command<Void> unremoveRepository(Author author, String projectName, String repositoryName) {
        return Command.unremoveRepository(null, author, projectName, repositoryName);
    }

    public static Command<Void> unremoveRepository(@Nullable Long timestamp, Author author, String projectName, String repositoryName) {
        Objects.requireNonNull(author, "author");
        return new UnremoveRepositoryCommand(timestamp, author, projectName, repositoryName);
    }

    public static Command<Void> purgeRepository(Author author, String projectName, String repositoryName) {
        Objects.requireNonNull(author, "author");
        return new PurgeRepositoryCommand(null, author, projectName, repositoryName);
    }

    public static Command<Void> purgeRepository(@Nullable Long timestamp, Author author, String projectName, String repositoryName) {
        Objects.requireNonNull(author, "author");
        return new PurgeRepositoryCommand(timestamp, author, projectName, repositoryName);
    }

    public static Command<Revision> push(Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Change<?> ... changes) {
        return Command.push(null, author, projectName, repositoryName, baseRevision, summary, detail, markup, changes);
    }

    public static Command<Revision> push(@Nullable Long timestamp, Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Change<?> ... changes) {
        Objects.requireNonNull(author, "author");
        Objects.requireNonNull(changes, "changes");
        return new PushCommand(timestamp, author, projectName, repositoryName, baseRevision, summary, detail, markup, Arrays.asList(changes));
    }

    public static Command<Revision> push(Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        return Command.push(null, author, projectName, repositoryName, baseRevision, summary, detail, markup, changes);
    }

    public static Command<Revision> push(@Nullable Long timestamp, Author author, String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Iterable<Change<?>> changes) {
        Objects.requireNonNull(author, "author");
        return new PushCommand(timestamp, author, projectName, repositoryName, baseRevision, summary, detail, markup, changes);
    }

    public static Command<Void> createSession(Session session) {
        return new CreateSessionCommand(null, null, session);
    }

    public static Command<Void> removeSession(String sessionId) {
        return new RemoveSessionCommand(null, null, sessionId);
    }

    public CommandType type();

    @JsonProperty
    public long timestamp();

    @JsonProperty
    public Author author();

    public String executionPath();
}

