/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository;

import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class RepositoryManagerWrapper
implements RepositoryManager {
    private final RepositoryManager delegate;
    private final Function<Repository, Repository> repoWrapper;
    private final ConcurrentMap<String, Repository> repos = new ConcurrentHashMap<String, Repository>();

    public RepositoryManagerWrapper(RepositoryManager repoManager, Function<Repository, Repository> repoWrapper) {
        this.delegate = Objects.requireNonNull(repoManager, "repoManager");
        this.repoWrapper = Objects.requireNonNull(repoWrapper, "repoWrapper");
        for (Map.Entry entry : this.delegate.list().entrySet()) {
            this.repos.computeIfAbsent(entry.getKey(), n -> (Repository)repoWrapper.apply((Repository)entry.getValue()));
        }
    }

    @Override
    public Project parent() {
        return this.delegate.parent();
    }

    @Override
    public void close(Supplier<CentralDogmaException> failureCauseSupplier) {
        this.delegate.close(failureCauseSupplier);
    }

    @Override
    public boolean exists(String name) {
        return this.delegate.exists(name);
    }

    @Override
    public Repository get(String name) {
        this.ensureOpen();
        Repository r = (Repository)this.repos.get(name);
        if (r == null) {
            throw new RepositoryNotFoundException(name);
        }
        return r;
    }

    @Override
    public Repository create(String name, long creationTimeMillis, Author author) {
        return this.repos.compute(name, (n, v) -> this.repoWrapper.apply((Repository)this.delegate.create(name, creationTimeMillis, author)));
    }

    @Override
    public Map<String, Repository> list() {
        this.ensureOpen();
        int estimatedSize = this.repos.size();
        Object[] names = this.repos.keySet().toArray(new String[estimatedSize]);
        Arrays.sort(names);
        LinkedHashMap<Object, Repository> ret = new LinkedHashMap<Object, Repository>(names.length);
        for (Object name : names) {
            Repository repo = (Repository)this.repos.get(name);
            if (repo == null) continue;
            ret.put(name, repo);
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public Set<String> listRemoved() {
        return this.delegate.listRemoved();
    }

    @Override
    public void remove(String name) {
        this.repos.compute(name, (n, v) -> {
            this.delegate.remove((String)n);
            return null;
        });
    }

    @Override
    public Repository unremove(String name) {
        this.ensureOpen();
        return this.repos.computeIfAbsent(name, n -> this.repoWrapper.apply((Repository)this.delegate.unremove((String)n)));
    }

    @Override
    public void ensureOpen() {
        this.delegate.ensureOpen();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(Util.simpleTypeName(this.getClass()) + '{');
        sb.append("repositoryManager=");
        sb.append(this.delegate);
        sb.append(", repos={");
        Iterator iterator = this.repos.entrySet().iterator();
        if (iterator.hasNext()) {
            while (true) {
                Map.Entry entry = iterator.next();
                sb.append((String)entry.getKey());
                sb.append('=');
                sb.append(Util.simpleTypeName(entry.getValue()));
                if (!iterator.hasNext()) break;
                sb.append(", ");
            }
        }
        sb.append("}}");
        return sb.toString();
    }
}

