/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.replication;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.zookeeper.server.PurgeTxnLog;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EmbeddedZooKeeper
extends QuorumPeer {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedZooKeeper.class);
    static final String SASL_SERVER_LOGIN_CONTEXT = "QuorumServer";
    static final String SASL_LEARNER_LOGIN_CONTEXT = "QuorumLearner";
    private final ServerCnxnFactory cnxnFactory;
    private final DatadirCleanupManager purgeManager;

    EmbeddedZooKeeper(QuorumPeerConfig zkCfg) throws IOException {
        this.cnxnFactory = EmbeddedZooKeeper.createCnxnFactory(zkCfg);
        this.setTxnFactory(new FileTxnSnapLog(zkCfg.getDataLogDir(), zkCfg.getDataDir()));
        this.enableLocalSessions(zkCfg.areLocalSessionsEnabled());
        this.enableLocalSessionsUpgrading(zkCfg.isLocalSessionsUpgradingEnabled());
        this.setElectionType(zkCfg.getElectionAlg());
        this.setMyid(zkCfg.getServerId());
        this.setTickTime(zkCfg.getTickTime());
        this.setMinSessionTimeout(zkCfg.getMinSessionTimeout());
        this.setMaxSessionTimeout(zkCfg.getMaxSessionTimeout());
        this.setInitLimit(zkCfg.getInitLimit());
        this.setSyncLimit(zkCfg.getSyncLimit());
        this.setConfigFileName(zkCfg.getConfigFilename());
        this.setZKDatabase(new ZKDatabase(this.getTxnFactory()));
        this.setQuorumVerifier(zkCfg.getQuorumVerifier(), false);
        if (zkCfg.getLastSeenQuorumVerifier() != null) {
            this.setLastSeenQuorumVerifier(zkCfg.getLastSeenQuorumVerifier(), false);
        }
        this.initConfigInZKDatabase();
        this.setCnxnFactory(this.cnxnFactory);
        this.setLearnerType(zkCfg.getPeerType());
        this.setSyncEnabled(zkCfg.getSyncEnabled());
        this.setQuorumListenOnAllIPs(zkCfg.getQuorumListenOnAllIPs());
        this.configureSasl();
        this.purgeManager = new DatadirCleanupManager(zkCfg.getDataDir(), zkCfg.getDataLogDir(), zkCfg.getSnapRetainCount(), zkCfg.getPurgeInterval());
    }

    private static ServerCnxnFactory createCnxnFactory(QuorumPeerConfig zkCfg) throws IOException {
        InetSocketAddress bindAddr = zkCfg.getClientPortAddress();
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        cnxnFactory.configure(new InetSocketAddress("127.0.0.1", bindAddr != null ? bindAddr.getPort() : 0), zkCfg.getMaxClientCnxns());
        return cnxnFactory;
    }

    private void configureSasl() {
        this.quorumServerSaslAuthRequired = true;
        this.quorumLearnerSaslAuthRequired = true;
        this.quorumServerLoginContext = SASL_SERVER_LOGIN_CONTEXT;
        this.quorumLearnerLoginContext = SASL_LEARNER_LOGIN_CONTEXT;
    }

    public synchronized void start() {
        this.purgeTxnLogs();
        this.purgeManager.start();
        super.start();
    }

    public void shutdown() {
        this.cnxnFactory.shutdown();
        this.purgeManager.shutdown();
        super.shutdown();
    }

    private void purgeTxnLogs() {
        logger.info("Purging old ZooKeeper snapshots and logs ..");
        try {
            PurgeTxnLog.purge((File)this.purgeManager.getDataLogDir(), (File)this.purgeManager.getSnapDir(), (int)this.purgeManager.getSnapRetainCount());
            logger.info("Purged old ZooKeeper snapshots and logs.");
        }
        catch (IOException e) {
            logger.error("Failed to purge old ZooKeeper snapshots and logs:", (Throwable)e);
        }
    }
}

