/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.plugin;

import com.linecorp.centraldogma.server.internal.plugin.PluginException;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;

public final class Polyfills {
    private static final Pattern FIRST_LINE = Pattern.compile("^[^\\r\\n]*");
    private static final Pattern SUBSTITUTIONS = Pattern.compile("%[%sdifjo]");
    private static final String[] INT2STR = new String[256];

    public static Throwable exception(Object err) {
        ScriptObjectMirror mirror;
        Object exception;
        if (err instanceof ScriptObjectMirror && (exception = (mirror = (ScriptObjectMirror)err).get((Object)"nashornException")) instanceof Throwable) {
            return new PluginException((Throwable)exception);
        }
        return new PluginException(String.valueOf(err));
    }

    @Nullable
    public static String loadResource(String path) throws IOException {
        try (InputStream in = Polyfills.class.getResourceAsStream(path);){
            int readBytes;
            if (in == null) {
                String string = null;
                return string;
            }
            byte[] buf = new byte[8192];
            ByteArrayOutputStream out = new ByteArrayOutputStream(buf.length);
            while ((readBytes = in.read(buf)) >= 0) {
                out.write(buf, 0, readBytes);
            }
            String string = out.toString(StandardCharsets.UTF_8.name());
            return string;
        }
    }

    public static Future<?> setImmediate(EventExecutor executor, Runnable task) {
        return executor.submit(task);
    }

    public static Future<?> setTimeout(EventExecutor executor, Runnable task, long delay) {
        if (delay <= 0L) {
            return executor.submit(task);
        }
        return executor.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public static void consoleTrace(Logger logger, String trace) {
        if (logger.isDebugEnabled()) {
            logger.debug(FIRST_LINE.matcher(trace).replaceAll("Stack trace:"));
        }
    }

    public static void consoleDebug(Logger logger, ScriptObjectMirror args) {
        if (logger.isDebugEnabled()) {
            logger.debug(Polyfills.logMessage(args));
        }
    }

    public static void consoleInfo(Logger logger, ScriptObjectMirror args) {
        if (logger.isInfoEnabled()) {
            logger.info(Polyfills.logMessage(args));
        }
    }

    public static void consoleWarn(Logger logger, ScriptObjectMirror args) {
        if (logger.isWarnEnabled()) {
            logger.warn(Polyfills.logMessage(args));
        }
    }

    public static void consoleError(Logger logger, ScriptObjectMirror args) {
        if (logger.isErrorEnabled()) {
            logger.error(Polyfills.logMessage(args));
        }
    }

    private static String logMessage(Object value) {
        int length = Polyfills.length(value);
        if (length < 0) {
            return String.valueOf(value);
        }
        if (length == 1) {
            ScriptObjectMirror firstMirror;
            Object first = ((Map)value).get("0");
            if (first instanceof ScriptObjectMirror && (firstMirror = (ScriptObjectMirror)first).isArray()) {
                return Polyfills.logMessage(firstMirror, Polyfills.length(firstMirror));
            }
            return String.valueOf(first);
        }
        return Polyfills.logMessage((ScriptObjectMirror)value, length);
    }

    private static String logMessage(ScriptObjectMirror mirror, int length) {
        String format;
        Object first = mirror.get((Object)"0");
        if (first instanceof String && SUBSTITUTIONS.matcher(format = (String)first).find()) {
            return Polyfills.logMessageFormat(format, mirror, length);
        }
        return Polyfills.logMessageSimple(new StringBuilder(64), mirror, 0, length);
    }

    private static String logMessageFormat(String format, ScriptObjectMirror values, int length) {
        StringBuilder buf = new StringBuilder(format.length() << 1);
        boolean wasPercent = false;
        int argIdx = 1;
        for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            if (wasPercent) {
                switch (ch) {
                    case '%': {
                        buf.append('%');
                        break;
                    }
                    case 'd': 
                    case 'f': 
                    case 'i': 
                    case 'j': 
                    case 'o': 
                    case 's': {
                        buf.append(values.get((Object)Polyfills.int2str(argIdx++)));
                        break;
                    }
                    default: {
                        buf.append('%');
                        buf.append(ch);
                    }
                }
                wasPercent = false;
                continue;
            }
            if (ch == '%') {
                wasPercent = true;
                continue;
            }
            buf.append(ch);
        }
        return Polyfills.logMessageSimple(buf, values, argIdx, length);
    }

    private static String logMessageSimple(StringBuilder out, ScriptObjectMirror values, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (out.length() != 0) {
                out.append(' ');
            }
            out.append(values.get((Object)Polyfills.int2str(i)));
        }
        return out.toString();
    }

    private static int length(Object value) {
        if (!(value instanceof ScriptObjectMirror)) {
            return -1;
        }
        ScriptObjectMirror mirror = (ScriptObjectMirror)value;
        Number length = (Number)mirror.get((Object)"length");
        if (length == null) {
            return -1;
        }
        return length.intValue();
    }

    private static String int2str(int value) {
        if ((value & 0xFFFFFF00) == 0) {
            return INT2STR[value];
        }
        return Integer.toString(value);
    }

    private Polyfills() {
    }

    static {
        for (int i = 0; i < INT2STR.length; ++i) {
            Polyfills.INT2STR[i] = String.valueOf(i);
        }
    }
}

