/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror.credential;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.mirror.credential.MirrorCredential;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

abstract class AbstractMirrorCredential
implements MirrorCredential {
    @Nullable
    private final String id;
    private final Set<Pattern> hostnamePatterns;
    private final Set<String> hostnamePatternStrings;

    AbstractMirrorCredential(@Nullable String id, @Nullable Iterable<Pattern> hostnamePatterns) {
        this.id = id;
        this.hostnamePatterns = AbstractMirrorCredential.validateHostnamePatterns(hostnamePatterns);
        this.hostnamePatternStrings = this.hostnamePatterns.stream().map(Pattern::pattern).collect(Collectors.toSet());
    }

    private static Set<Pattern> validateHostnamePatterns(@Nullable Iterable<Pattern> hostnamePatterns) {
        if (hostnamePatterns == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Iterable)Util.requireNonNullElements(hostnamePatterns, (String)"hostnamePatterns"));
    }

    @Override
    public final Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    public final Set<Pattern> hostnamePatterns() {
        return this.hostnamePatterns;
    }

    @Override
    public final boolean matches(URI uri) {
        Objects.requireNonNull(uri, "uri");
        String host = uri.getHost();
        return host != null && this.hostnamePatterns.stream().anyMatch(p -> p.matcher(host).matches());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMirrorCredential that = (AbstractMirrorCredential)o;
        return this.hostnamePatternStrings.equals(that.hostnamePatternStrings);
    }

    public int hashCode() {
        return this.hostnamePatternStrings.hashCode();
    }

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        if (this.id != null) {
            helper.add("id", (Object)this.id);
        }
        if (!this.hostnamePatterns.isEmpty()) {
            helper.add("hostnamePatterns", this.hostnamePatterns);
        }
        this.addProperties(helper);
        return helper.toString();
    }

    abstract void addProperties(MoreObjects.ToStringHelper var1);
}

