/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.common.Author;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;

public final class UserAndTimestamp {
    private final String user;
    private final Instant timestamp;
    @Nullable
    private String timestampAsText;

    public UserAndTimestamp(String user) {
        this(user, Instant.now());
    }

    public UserAndTimestamp(String user, Instant timestamp) {
        this.user = Objects.requireNonNull(user, "user");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
    }

    @JsonCreator
    UserAndTimestamp(@JsonProperty(value="user") String user, @JsonProperty(value="timestamp") String timestampAsText) {
        this.user = Objects.requireNonNull(user, "user");
        this.timestampAsText = Objects.requireNonNull(timestampAsText, "timestampAsText");
        this.timestamp = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(timestampAsText));
    }

    @JsonProperty
    public String user() {
        return this.user;
    }

    @JsonProperty
    public String timestamp() {
        if (this.timestampAsText == null) {
            this.timestampAsText = DateTimeFormatter.ISO_INSTANT.format(this.timestamp);
        }
        return this.timestampAsText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAndTimestamp that = (UserAndTimestamp)o;
        return this.user.equals(that.user) && this.timestamp.equals(that.timestamp);
    }

    public int hashCode() {
        return this.user.hashCode() * 31 + this.timestamp.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.user()).add("timestamp", (Object)this.timestamp()).toString();
    }

    public static UserAndTimestamp of(Author author) {
        return new UserAndTimestamp(Objects.requireNonNull(author, "author").email());
    }
}

