/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.google.common.base.Ascii;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.centraldogma.common.Revision;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public final class WatchRequestConverter
implements RequestConverterFunction {
    private static final long DEFAULT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(120L);

    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpMessage request, Class<?> expectedResultType) throws Exception {
        String ifNoneMatch = (String)request.headers().get((Object)HttpHeaderNames.IF_NONE_MATCH);
        if (!Strings.isNullOrEmpty((String)ifNoneMatch)) {
            Revision lastKnownRevision = new Revision(ifNoneMatch);
            String prefer = (String)request.headers().get((Object)HttpHeaderNames.PREFER);
            long timeoutMillis = !Strings.isNullOrEmpty((String)prefer) ? WatchRequestConverter.getTimeoutMillis(prefer) : DEFAULT_TIMEOUT_MILLIS;
            return Optional.of(new WatchRequest(lastKnownRevision, timeoutMillis));
        }
        return Optional.empty();
    }

    private static long getTimeoutMillis(String preferHeader) {
        long timeoutSeconds;
        String prefer = Ascii.toLowerCase((String)preferHeader.replaceAll("\\s+", ""));
        if (!prefer.startsWith("wait=")) {
            return WatchRequestConverter.rejectPreferHeader(preferHeader);
        }
        try {
            timeoutSeconds = Long.parseLong(prefer.substring("wait=".length()));
        }
        catch (NumberFormatException e) {
            return WatchRequestConverter.rejectPreferHeader(preferHeader);
        }
        if (timeoutSeconds <= 0L) {
            return WatchRequestConverter.rejectPreferHeader(preferHeader);
        }
        return TimeUnit.SECONDS.toMillis(timeoutSeconds);
    }

    private static long rejectPreferHeader(String preferHeader) {
        throw new IllegalArgumentException("invalid prefer header: " + preferHeader + " (expected: wait=seconds)");
    }

    public static class WatchRequest {
        private final Revision lastKnownRevision;
        private final long timeoutMillis;

        WatchRequest(Revision lastKnownRevision, long timeoutMillis) {
            this.lastKnownRevision = lastKnownRevision;
            this.timeoutMillis = timeoutMillis;
        }

        public Revision lastKnownRevision() {
            return this.lastKnownRevision;
        }

        public long timeoutMillis() {
            return this.timeoutMillis;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lastKnownRevision", (Object)this.lastKnownRevision).add("timeoutMillis", this.timeoutMillis).toString();
        }
    }
}

