/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.metadata.HolderWithLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateApiResponseConverter
implements ResponseConverterFunction {
    private static final Logger logger = LoggerFactory.getLogger(CreateApiResponseConverter.class);

    public HttpResponse convertResponse(ServiceRequestContext ctx, Object resObj) throws Exception {
        try {
            if (resObj instanceof HolderWithLocation) {
                return CreateApiResponseConverter.handleWithLocation((HolderWithLocation)resObj);
            }
            JsonNode jsonNode = Jackson.valueToTree((Object)resObj);
            String url = jsonNode.get("url").asText();
            ((ObjectNode)jsonNode).remove("url");
            HttpHeaders headers = ((HttpHeaders)HttpHeaders.of((HttpStatus)HttpStatus.CREATED).add((Object)HttpHeaderNames.LOCATION, (Object)url)).contentType(MediaType.JSON_UTF_8);
            return HttpResponse.of((HttpHeaders)headers, (HttpData)HttpData.of((byte[])Jackson.writeValueAsBytes((Object)jsonNode)));
        }
        catch (JsonProcessingException e) {
            logger.debug("Failed to convert a response:", (Throwable)e);
            return HttpApiUtil.newResponse(HttpStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    private static HttpResponse handleWithLocation(HolderWithLocation<?> holderWithLocation) throws JsonProcessingException {
        return HttpResponse.of((HttpHeaders)((HttpHeaders)HttpHeaders.of((HttpStatus)HttpStatus.CREATED).add((Object)HttpHeaderNames.LOCATION, (Object)holderWithLocation.location())).contentType(MediaType.JSON_UTF_8), (HttpData)HttpData.of((byte[])Jackson.writeValueAsBytes(holderWithLocation.object())));
    }
}

