/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.JacksonRequestConverterFunction;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.ChangeType;

public final class ChangesRequestConverter
extends JacksonRequestConverterFunction {
    public Object convertRequest(ServiceRequestContext ctx, AggregatedHttpMessage request, Class<?> expectedResultType) throws Exception {
        JsonNode node = (JsonNode)super.convertRequest(ctx, request, JsonNode.class);
        if (node.get("changes") != null) {
            JsonNode changeNode = node.get("changes");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonNode change : changeNode) {
                builder.add(ChangesRequestConverter.readChange(change));
            }
            ImmutableList changes = builder.build();
            Preconditions.checkArgument((!changes.isEmpty() ? 1 : 0) != 0, (Object)"should have at least one change.");
            return changes;
        }
        return ImmutableList.of(ChangesRequestConverter.readChange(node));
    }

    private static Change<?> readChange(JsonNode node) {
        Preconditions.checkArgument((node.get("path") != null && node.get("type") != null ? 1 : 0) != 0, (Object)"a change should have a path and a type");
        ChangeType changeType = ChangeType.parse((String)node.get("type").textValue());
        if (changeType != ChangeType.REMOVE) {
            Preconditions.checkArgument((node.get("content") != null ? 1 : 0) != 0, (Object)"a change should have a content.");
        }
        String path = node.get("path").textValue();
        if (changeType == ChangeType.UPSERT_TEXT) {
            return Change.ofTextUpsert((String)path, (String)node.get("content").textValue());
        }
        if (changeType == ChangeType.UPSERT_JSON) {
            return Change.ofJsonUpsert((String)path, (JsonNode)node.get("content"));
        }
        if (changeType == ChangeType.REMOVE) {
            return Change.ofRemoval((String)path);
        }
        if (changeType == ChangeType.RENAME) {
            return Change.ofRename((String)path, (String)node.get("content").textValue());
        }
        if (changeType == ChangeType.APPLY_TEXT_PATCH) {
            return Change.ofTextPatch((String)path, (String)node.get("content").textValue());
        }
        if (changeType == ChangeType.APPLY_JSON_PATCH) {
            return Change.ofJsonPatch((String)path, (JsonNode)node.get("content"));
        }
        throw new Error();
    }
}

