/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.converter.CreateApiResponseConverter;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.HolderWithLocation;
import com.linecorp.centraldogma.server.internal.metadata.MetadataService;
import com.linecorp.centraldogma.server.internal.metadata.Token;
import com.linecorp.centraldogma.server.internal.metadata.Tokens;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class TokenService
extends AbstractService {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private static final JsonNode activation = Jackson.valueToTree((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"op", (Object)"replace", (Object)"path", (Object)"/status", (Object)"value", (Object)"active")));
    private static final JsonNode deactivation = Jackson.valueToTree((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"op", (Object)"replace", (Object)"path", (Object)"/status", (Object)"value", (Object)"inactive")));
    private final MetadataService mds;

    public TokenService(ProjectManager projectManager, CommandExecutor executor, MetadataService mds) {
        super(projectManager, executor);
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    @Get(value="/tokens")
    public CompletableFuture<Collection<Token>> listTokens(User loginUser) {
        if (loginUser.isAdmin()) {
            return this.mds.getTokens().thenApply(tokens -> tokens.appIds().values());
        }
        return ((CompletableFuture)this.mds.getTokens().thenApply(Tokens::withoutSecret)).thenApply(tokens -> tokens.appIds().values());
    }

    @Post(value="/tokens")
    @ResponseConverter(value=CreateApiResponseConverter.class)
    public CompletableFuture<HolderWithLocation<Token>> createToken(@Param(value="appId") String appId, @Param(value="isAdmin") boolean isAdmin, Author author, User loginUser) {
        Preconditions.checkArgument((!isAdmin || loginUser.isAdmin() ? 1 : 0) != 0, (Object)"Only administrators are allowed to create an admin-level token.");
        return ((CompletableFuture)this.mds.createToken(author, appId, isAdmin).thenCompose(unused -> this.mds.findTokenByAppId(appId))).thenApply(token -> HolderWithLocation.of(token, "/tokens/" + appId));
    }

    @Delete(value="/tokens/{appId}")
    public CompletableFuture<Token> deleteToken(@Param(value="appId") String appId, Author author, User loginUser) {
        return this.getTokenOrRespondForbidden(appId, loginUser).thenCompose(token -> this.mds.destroyToken(author, appId).thenApply(unused -> token.withoutSecret()));
    }

    @Patch(value="/tokens/{appId}")
    @Consumes(value="application/json-patch+json")
    public CompletableFuture<Token> updateToken(@Param(value="appId") String appId, JsonNode node, Author author, User loginUser) {
        if (node.equals((Object)activation)) {
            return this.getTokenOrRespondForbidden(appId, loginUser).thenCompose(token -> this.mds.activateToken(author, appId).thenApply(unused -> token.withoutSecret()));
        }
        if (node.equals((Object)deactivation)) {
            return this.getTokenOrRespondForbidden(appId, loginUser).thenCompose(token -> this.mds.deactivateToken(author, appId).thenApply(unused -> token.withoutSecret()));
        }
        throw new IllegalArgumentException("Unsupported JSON patch: " + node + " (expected: " + activation + " or " + deactivation + ')');
    }

    private CompletableFuture<Token> getTokenOrRespondForbidden(String appId, User loginUser) {
        return this.mds.findTokenByAppId(appId).thenApply(token -> {
            if (!loginUser.isAdmin() && !token.creation().user().equals(loginUser.id())) {
                return (Token)HttpApiUtil.throwResponse(HttpStatus.FORBIDDEN, "Unauthorized token: %s", token);
            }
            return token;
        });
    }
}

