/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.internal.api.v1.CreateProjectRequest;
import com.linecorp.centraldogma.internal.api.v1.ProjectDto;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.AdministratorsOnly;
import com.linecorp.centraldogma.server.internal.api.auth.ProjectMembersOnly;
import com.linecorp.centraldogma.server.internal.api.auth.ProjectOwnersOnly;
import com.linecorp.centraldogma.server.internal.api.converter.CreateApiResponseConverter;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.MetadataService;
import com.linecorp.centraldogma.server.internal.metadata.ProjectMetadata;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class ProjectServiceV1
extends AbstractService {
    private final MetadataService mds;

    public ProjectServiceV1(ProjectManager projectManager, CommandExecutor executor, MetadataService mds) {
        super(projectManager, executor);
        this.mds = Objects.requireNonNull(mds, "mds");
    }

    @Get(value="/projects")
    public CompletableFuture<List<ProjectDto>> listProjects(@Param(value="status") Optional<String> status) {
        if (status.isPresent()) {
            HttpApiUtil.checkStatusArgument(status.get());
            return CompletableFuture.supplyAsync(() -> (ImmutableList)this.projectManager().listRemoved().stream().map(ProjectDto::new).collect(ImmutableList.toImmutableList()));
        }
        return CompletableFuture.supplyAsync(() -> (ImmutableList)this.projectManager().list().values().stream().map(DtoConverter::convert).collect(ImmutableList.toImmutableList()));
    }

    @Post(value="/projects")
    @ResponseConverter(value=CreateApiResponseConverter.class)
    public CompletableFuture<ProjectDto> createProject(CreateProjectRequest request, Author author) {
        return this.execute(Command.createProject(author, request.name())).handle(HttpApiUtil.returnOrThrow(() -> DtoConverter.convert((Project)this.projectManager().get(request.name()))));
    }

    @Get(value="/projects/{projectName}")
    @Decorator(value=ProjectMembersOnly.class)
    public CompletableFuture<ProjectMetadata> getProjectMetadata(@Param(value="projectName") String projectName, @Param(value="checkPermissionOnly") Optional<Boolean> isCheckPermissionOnly) {
        if (isCheckPermissionOnly.orElse(false).booleanValue()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.mds.getProject(projectName);
    }

    @Delete(value="/projects/{projectName}")
    @Decorator(value=ProjectOwnersOnly.class)
    public CompletableFuture<Void> removeProject(Project project, Author author) {
        return ((CompletableFuture)this.mds.removeProject(author, project.name()).thenCompose(unused -> this.execute(Command.removeProject(author, project.name())))).handle(HttpApiUtil::throwUnsafelyIfNonNull);
    }

    @Consumes(value="application/json-patch+json")
    @Patch(value="/projects/{projectName}")
    @Decorator(value=AdministratorsOnly.class)
    public CompletableFuture<ProjectDto> patchProject(@Param(value="projectName") String projectName, JsonNode node, Author author) {
        HttpApiUtil.checkUnremoveArgument(node);
        return ((CompletableFuture)this.execute(Command.unremoveProject(author, projectName)).thenCompose(unused -> this.mds.restoreProject(author, projectName))).handle(HttpApiUtil.returnOrThrow(() -> DtoConverter.convert((Project)this.projectManager().get(projectName))));
    }
}

