/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.api.auth.AdministratorsOnly;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdministrativeService
extends AbstractService {
    private static final Logger logger = LoggerFactory.getLogger(AdministrativeService.class);

    public AdministrativeService(ProjectManager projectManager, CommandExecutor executor) {
        super(projectManager, executor);
    }

    @Get(value="/status")
    public ServerStatus status() {
        return new ServerStatus(this.executor().isWritable(), this.executor().isStarted());
    }

    @Patch(value="/status")
    @Consumes(value="application/json-patch+json")
    @Decorator(value=AdministratorsOnly.class)
    public CompletableFuture<ServerStatus> updateStatus(JsonNode patch) throws Exception {
        JsonNode newValue;
        ServerStatus oldStatus = this.status();
        JsonNode oldValue = Jackson.valueToTree((Object)oldStatus);
        try {
            newValue = JsonPatch.fromJson((JsonNode)patch).apply(oldValue);
        }
        catch (JsonPatchException e) {
            return AdministrativeService.rejectStatusPatch(patch);
        }
        if (!newValue.isObject()) {
            return AdministrativeService.rejectStatusPatch(patch);
        }
        JsonNode writableNode = newValue.get("writable");
        JsonNode replicatingNode = newValue.get("replicating");
        if (!writableNode.isBoolean() || !replicatingNode.isBoolean()) {
            return AdministrativeService.rejectStatusPatch(patch);
        }
        boolean writable = writableNode.asBoolean();
        boolean replicating = replicatingNode.asBoolean();
        if (writable && !replicating) {
            return (CompletableFuture)HttpApiUtil.throwResponse(HttpStatus.BAD_REQUEST, "'replicating' must be 'true' if 'writable' is 'true'.");
        }
        if (oldStatus.writable) {
            if (!writable) {
                this.executor().setWritable(false);
                if (replicating) {
                    logger.warn("Entered read-only mode with replication enabled");
                    return CompletableFuture.completedFuture(this.status());
                }
                logger.warn("Entering read-only mode with replication disabled ..");
                return this.executor().stop().handle((unused, cause) -> {
                    if (cause != null) {
                        logger.warn("Failed to stop the command executor:", cause);
                    } else {
                        logger.info("Entered read-only mode with replication disabled");
                    }
                    return this.status();
                });
            }
        } else if (writable) {
            logger.warn("Leaving read-only mode ..");
            this.executor().setWritable(true);
            return this.executor().start().handle((unused, cause) -> {
                if (cause != null) {
                    logger.warn("Failed to leave read-only mode:", cause);
                } else {
                    logger.info("Left read-only mode");
                }
                return this.status();
            });
        }
        throw HttpStatusException.of((HttpStatus)HttpStatus.NOT_MODIFIED);
    }

    private static CompletableFuture<ServerStatus> rejectStatusPatch(JsonNode patch) {
        throw new IllegalArgumentException("Invalid JSON patch: " + patch);
    }

    private static final class ServerStatus {
        @JsonProperty
        final boolean writable;
        @JsonProperty
        final boolean replicating;

        ServerStatus(boolean writable, boolean replicating) {
            assert (!writable || replicating);
            this.writable = writable;
            this.replicating = replicating;
        }
    }
}

