/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.Path;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.server.internal.admin.authentication.AuthenticationUtil;
import com.linecorp.centraldogma.server.internal.admin.dto.ChangeDto;
import com.linecorp.centraldogma.server.internal.admin.dto.CommitDto;
import com.linecorp.centraldogma.server.internal.admin.dto.CommitMessageDto;
import com.linecorp.centraldogma.server.internal.admin.dto.EntryDto;
import com.linecorp.centraldogma.server.internal.admin.dto.RevisionDto;
import com.linecorp.centraldogma.server.internal.admin.service.DtoConverter;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.HttpApiExceptionHandler;
import com.linecorp.centraldogma.server.internal.api.auth.HasReadPermission;
import com.linecorp.centraldogma.server.internal.api.auth.HasWritePermission;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.FindOption;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@ExceptionHandler(value=HttpApiExceptionHandler.class)
public class RepositoryService
extends AbstractService {
    private static final Map<FindOption<?>, Object> LIST_FILES_FIND_OPTIONS = new IdentityHashMap();
    private static final Object VOID = new Object();
    private static final Splitter termSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings();

    public RepositoryService(ProjectManager projectManager, CommandExecutor executor) {
        super(projectManager, executor);
    }

    @Get(value="/projects/{projectName}/repositories/{repoName}/revision/{revision}")
    @Decorator(value=HasReadPermission.class)
    public RevisionDto normalizeRevision(@Param(value="projectName") String projectName, @Param(value="repoName") String repoName, @Param(value="revision") String revision) {
        return DtoConverter.convert(((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).normalizeNow(new Revision(revision)));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repositories/(?<repoName>[^/]+)/files/revisions/(?<revision>[^/]+)(?<path>/.*$)")
    @Decorator(value=HasReadPermission.class)
    public CompletionStage<EntryDto> getFile(@Param(value="projectName") String projectName, @Param(value="repoName") String repoName, @Param(value="revision") String revision, @Param(value="path") String path, @Param(value="queryType") Optional<String> queryType, @Param(value="expression") Optional<String> expressions) {
        Query query = Query.of((QueryType)QueryType.valueOf((String)queryType.orElse("IDENTITY")), (String)path, (String[])new String[]{expressions.orElse("")});
        Repository repo = (Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName);
        return repo.get(repo.normalizeNow(new Revision(revision)), query).thenApply(DtoConverter::convert);
    }

    @Post
    @Put
    @Path(value="/projects/{projectName}/repositories/{repoName}/files/revisions/{revision}")
    @Decorator(value=HasWritePermission.class)
    public CompletionStage<Object> addOrEditFile(@Param(value="projectName") String projectName, @Param(value="repoName") String repoName, @Param(value="revision") String revision, AggregatedHttpMessage message, ServiceRequestContext ctx) {
        Map.Entry<CommitMessageDto, Change<?>> p = RepositoryService.commitMessageAndChange(message);
        CommitMessageDto commitMessage = p.getKey();
        Change<?> change = p.getValue();
        return this.push(projectName, repoName, new Revision(revision), AuthenticationUtil.currentAuthor(ctx), commitMessage.getSummary(), commitMessage.getDetail().getContent(), Markup.valueOf((String)commitMessage.getDetail().getMarkup()), change).thenApply(unused -> VOID);
    }

    @Post(value="regex:/projects/(?<projectName>[^/]+)/repositories/(?<repoName>[^/]+)/delete/revisions/(?<revision>[^/]+)(?<path>/.*$)")
    @Decorator(value=HasWritePermission.class)
    public HttpResponse deleteFile(@Param(value="projectName") String projectName, @Param(value="repoName") String repoName, @Param(value="revision") String revision, @Param(value="path") String path, AggregatedHttpMessage message, ServiceRequestContext ctx) {
        CommitMessageDto commitMessage;
        try {
            JsonNode node = Jackson.readTree((String)message.content().toStringUtf8());
            commitMessage = (CommitMessageDto)Jackson.convertValue((Object)node.get("commitMessage"), CommitMessageDto.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid data to be parsed", e);
        }
        CompletableFuture<?> future = this.push(projectName, repoName, new Revision(revision), AuthenticationUtil.currentAuthor(ctx), commitMessage.getSummary(), commitMessage.getDetail().getContent(), Markup.valueOf((String)commitMessage.getDetail().getMarkup()), Change.ofRemoval((String)path));
        return HttpResponse.from((CompletionStage)future.thenApply(unused -> HttpResponse.of((HttpStatus)HttpStatus.OK)));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repositories/(?<repoName>[^/]+)/history(?<path>/.*$)")
    @Decorator(value=HasReadPermission.class)
    public CompletionStage<List<CommitDto>> getHistory(@Param(value="projectName") String projectName, @Param(value="repoName") String repoName, @Param(value="path") String path, @Param(value="from") Optional<String> from, @Param(value="to") Optional<String> to) {
        return ((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).history(new Revision(from.orElse("-1")), new Revision(to.orElse("1")), path + "**").thenApply(commits -> commits.stream().map(DtoConverter::convert).collect(Collectors.toList()));
    }

    @Get(value="/projects/{projectName}/repositories/{repoName}/search/revisions/{revision}")
    @Decorator(value=HasReadPermission.class)
    public CompletionStage<List<EntryDto>> search(@Param(value="projectName") String projectName, @Param(value="repoName") String repoName, @Param(value="revision") String revision, @Param(value="term") String term) {
        return ((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).find(new Revision(revision), RepositoryService.normalizeSearchTerm(term), LIST_FILES_FIND_OPTIONS).thenApply(entries -> entries.values().stream().map(DtoConverter::convert).collect(Collectors.toList()));
    }

    @Get(value="regex:/projects/(?<projectName>[^/]+)/repositories/(?<repoName>[^/]+)/diff(?<path>/.*$)")
    @Decorator(value=HasReadPermission.class)
    public CompletionStage<List<ChangeDto>> getDiff(@Param(value="projectName") String projectName, @Param(value="repoName") String repoName, @Param(value="path") String path, @Param(value="from") String from, @Param(value="to") String to) {
        return ((Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName)).diff(new Revision(from), new Revision(to), path).thenApply(changeMap -> changeMap.values().stream().map(DtoConverter::convert).collect(Collectors.toList()));
    }

    private CompletableFuture<?> push(String projectName, String repoName, Revision revision, Author author, String commitSummary, String commitDetail, Markup commitMarkup, Change<?> change) {
        Repository repo = (Repository)((Project)this.projectManager().get(projectName)).repos().get(repoName);
        return this.push0(projectName, repoName, repo.normalizeNow(revision), author, commitSummary, commitDetail, commitMarkup, change);
    }

    private CompletableFuture<?> push0(String projectName, String repoName, Revision normalizedRev, Author author, String commitSummary, String commitDetail, Markup commitMarkup, Change<?> change) {
        CompletableFuture<Map<String, Change<?>>> f = RepositoryService.normalizeChanges(this.projectManager(), projectName, repoName, normalizedRev, ImmutableList.of(change));
        return f.thenCompose(changes -> this.execute(Command.push(author, projectName, repoName, normalizedRev, commitSummary, commitDetail, commitMarkup, changes.values())));
    }

    private static Map.Entry<CommitMessageDto, Change<?>> commitMessageAndChange(AggregatedHttpMessage message) {
        try {
            Change change;
            JsonNode node = Jackson.readTree((String)message.content().toStringUtf8());
            CommitMessageDto commitMessage = (CommitMessageDto)Jackson.convertValue((Object)node.get("commitMessage"), CommitMessageDto.class);
            EntryDto file = (EntryDto)Jackson.convertValue((Object)node.get("file"), EntryDto.class);
            switch (file.getType()) {
                case "JSON": {
                    change = Change.ofJsonUpsert((String)file.getPath(), (String)file.getContent());
                    break;
                }
                case "TEXT": {
                    change = Change.ofTextUpsert((String)file.getPath(), (String)file.getContent());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported file type: " + file.getType());
                }
            }
            return Maps.immutableEntry((Object)commitMessage, (Object)change);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid data to be parsed", e);
        }
    }

    private static CompletableFuture<Map<String, Change<?>>> normalizeChanges(ProjectManager projectManager, String projectName, String repoName, Revision baseRevision, Iterable<Change<?>> changes) {
        return ((Repository)((Project)projectManager.get(projectName)).repos().get(repoName)).previewDiff(baseRevision, changes);
    }

    private static String normalizeSearchTerm(String term) {
        if (Strings.isNullOrEmpty((String)term)) {
            throw new IllegalArgumentException("term should not be empty");
        }
        StringBuilder sb = new StringBuilder();
        for (String term0 : termSplitter.split((CharSequence)term)) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (term0.matches(".*[/*]+.*")) {
                sb.append(term0);
                continue;
            }
            sb.append('*').append(term0).append('*');
        }
        return sb.toString();
    }
}

