/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.admin.authentication;

import com.github.benmanes.caffeine.cache.Cache;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.AuthTokenExtractors;
import com.linecorp.armeria.server.auth.OAuth2Token;
import com.linecorp.centraldogma.internal.api.v1.AccessToken;
import com.linecorp.centraldogma.server.internal.admin.authentication.CentralDogmaSecurityManager;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import com.linecorp.centraldogma.server.internal.command.Command;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutService
extends AbstractHttpService {
    private static final Logger logger = LoggerFactory.getLogger(LogoutService.class);
    private final CentralDogmaSecurityManager securityManager;
    private final CommandExecutor executor;
    private final Cache<String, AccessToken> cache;

    public LogoutService(CentralDogmaSecurityManager securityManager, CommandExecutor executor, Cache<String, AccessToken> cache) {
        this.securityManager = Objects.requireNonNull(securityManager, "securityManager");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.cache = Objects.requireNonNull(cache, "cache");
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        CompletableFuture future = new CompletableFuture();
        ((CompletableFuture)req.aggregate().thenAccept(aMsg -> {
            OAuth2Token token = (OAuth2Token)AuthTokenExtractors.OAUTH2.apply(aMsg.headers());
            if (token == null) {
                future.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                return;
            }
            ctx.blockingTaskExecutor().execute(() -> {
                String sessionId = token.accessToken();
                ThreadContext.bind((SecurityManager)this.securityManager);
                try {
                    if (this.securityManager.sessionExists(sessionId)) {
                        Subject currentUser = new Subject.Builder((SecurityManager)this.securityManager).sessionCreationEnabled(false).sessionId((Serializable)((Object)sessionId)).buildSubject();
                        String username = (String)currentUser.getPrincipal();
                        currentUser.logout();
                        this.cache.invalidate((Object)username);
                        this.executor.execute(Command.removeSession(sessionId)).join();
                        logger.info("{} Logged out: {} ({})", new Object[]{ctx, username, sessionId});
                    } else {
                        logger.debug("{} Tried to log out a non-existent session: {}", (Object)ctx, (Object)sessionId);
                    }
                    future.complete(HttpResponse.of((HttpStatus)HttpStatus.OK));
                }
                catch (Throwable t) {
                    logger.warn("{} Failed to log out: {}", new Object[]{ctx, sessionId, t});
                    future.complete(HttpApiUtil.newResponse(HttpStatus.INTERNAL_SERVER_ERROR, t));
                }
                finally {
                    ThreadContext.unbindSecurityManager();
                }
            });
        })).exceptionally(Functions.voidFunction(cause -> {
            logger.warn("{} Unexpected exception:", (Object)ctx, cause);
            future.complete(HttpApiUtil.newResponse(HttpStatus.INTERNAL_SERVER_ERROR, cause));
        }));
        return HttpResponse.from(future);
    }
}

