/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ZooKeeperAddress {
    private final String host;
    private final int quorumPort;
    private final int electionPort;
    private final int clientPort;

    @JsonCreator
    public ZooKeeperAddress(@JsonProperty(value="host", required=true) String host, @JsonProperty(value="quorumPort", required=true) int quorumPort, @JsonProperty(value="electionPort", required=true) int electionPort, @JsonProperty(value="clientPort", defaultValue="0") int clientPort) {
        this.host = Objects.requireNonNull(host, "host");
        this.quorumPort = ZooKeeperAddress.validatePort(quorumPort, "quorumPort");
        this.electionPort = ZooKeeperAddress.validatePort(electionPort, "electionPort");
        Preconditions.checkArgument((clientPort >= 0 && clientPort <= 65535 ? 1 : 0) != 0, (String)"clientPort: %s (expected: 0-65535)", (int)clientPort);
        this.clientPort = clientPort;
    }

    private static int validatePort(int port, String name) {
        Preconditions.checkArgument((port > 0 && port <= 65535 ? 1 : 0) != 0, (String)"%s: %s (expected: 1-65535)", (Object)name, (int)port);
        return port;
    }

    @JsonProperty
    public String host() {
        return this.host;
    }

    @JsonProperty
    public int quorumPort() {
        return this.quorumPort;
    }

    @JsonProperty
    public int electionPort() {
        return this.electionPort;
    }

    @JsonProperty
    public int clientPort() {
        return this.clientPort;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.quorumPort, this.electionPort, this.clientPort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZooKeeperAddress that = (ZooKeeperAddress)o;
        return this.host.equals(that.host) && this.quorumPort == that.quorumPort && this.electionPort == that.electionPort && this.clientPort == that.clientPort;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.host).add("quorumPort", this.quorumPort).add("electionPort", this.electionPort).add("clientPort", this.clientPort).toString();
    }
}

