/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.base.Ascii;
import com.google.common.base.Strings;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.util.EventLoopGroups;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.StartStopSupport;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.auth.Authorizer;
import com.linecorp.armeria.server.auth.HttpAuthService;
import com.linecorp.armeria.server.docs.DocServiceBuilder;
import com.linecorp.armeria.server.encoding.HttpEncodingService;
import com.linecorp.armeria.server.file.AbstractHttpVfs;
import com.linecorp.armeria.server.file.HttpFileService;
import com.linecorp.armeria.server.file.HttpVfs;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.HttpHealthCheckService;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import com.linecorp.armeria.server.thrift.THttpService;
import com.linecorp.armeria.server.thrift.ThriftCallService;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.api.v1.AccessToken;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaService;
import com.linecorp.centraldogma.server.CacheStatsSerializer;
import com.linecorp.centraldogma.server.CentralDogmaConfig;
import com.linecorp.centraldogma.server.MirroringService;
import com.linecorp.centraldogma.server.ReplicationMethod;
import com.linecorp.centraldogma.server.TlsConfig;
import com.linecorp.centraldogma.server.ZooKeeperReplicationConfig;
import com.linecorp.centraldogma.server.internal.admin.authentication.CentralDogmaSecurityManager;
import com.linecorp.centraldogma.server.internal.admin.authentication.CsrfTokenAuthorizer;
import com.linecorp.centraldogma.server.internal.admin.authentication.LoginService;
import com.linecorp.centraldogma.server.internal.admin.authentication.LogoutService;
import com.linecorp.centraldogma.server.internal.admin.authentication.SessionTokenAuthorizer;
import com.linecorp.centraldogma.server.internal.admin.service.RepositoryService;
import com.linecorp.centraldogma.server.internal.admin.service.UserService;
import com.linecorp.centraldogma.server.internal.admin.util.RestfulJsonResponseConverter;
import com.linecorp.centraldogma.server.internal.api.AdministrativeService;
import com.linecorp.centraldogma.server.internal.api.ContentServiceV1;
import com.linecorp.centraldogma.server.internal.api.MetadataApiService;
import com.linecorp.centraldogma.server.internal.api.ProjectServiceV1;
import com.linecorp.centraldogma.server.internal.api.RepositoryServiceV1;
import com.linecorp.centraldogma.server.internal.api.TokenService;
import com.linecorp.centraldogma.server.internal.api.WatchService;
import com.linecorp.centraldogma.server.internal.api.auth.ApplicationTokenAuthorizer;
import com.linecorp.centraldogma.server.internal.api.converter.HttpApiRequestConverter;
import com.linecorp.centraldogma.server.internal.api.converter.HttpApiResponseConverter;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.command.ProjectInitializer;
import com.linecorp.centraldogma.server.internal.command.StandaloneCommandExecutor;
import com.linecorp.centraldogma.server.internal.metadata.MetadataService;
import com.linecorp.centraldogma.server.internal.metadata.MetadataServiceInjector;
import com.linecorp.centraldogma.server.internal.metadata.MigrationUtil;
import com.linecorp.centraldogma.server.internal.mirror.DefaultMirroringService;
import com.linecorp.centraldogma.server.internal.replication.ZooKeeperCommandExecutor;
import com.linecorp.centraldogma.server.internal.storage.project.DefaultProjectManager;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import com.linecorp.centraldogma.server.internal.storage.project.SafeProjectManager;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import com.linecorp.centraldogma.server.internal.thrift.CentralDogmaExceptionTranslator;
import com.linecorp.centraldogma.server.internal.thrift.CentralDogmaServiceImpl;
import com.linecorp.centraldogma.server.internal.thrift.CentralDogmaTimeoutScheduler;
import com.linecorp.centraldogma.server.internal.thrift.TokenlessClientLogger;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralDogma
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CentralDogma.class);
    private final CentralDogmaConfig cfg;
    @Nullable
    private final Ini securityConfig;
    private final StartStopSupport<Void, Void> startStop = new CentralDogmaStartStop();
    private final AtomicInteger numPendingStopRequests = new AtomicInteger();
    @Nullable
    private volatile ProjectManager pm;
    @Nullable
    private volatile Server server;
    @Nullable
    private ExecutorService repositoryWorker;
    @Nullable
    private CommandExecutor executor;
    @Nullable
    private DefaultMirroringService mirroringService;

    public static CentralDogma forConfig(File configFile, @Nullable Ini securityConfig) throws IOException {
        Objects.requireNonNull(configFile, "configFile");
        return new CentralDogma((CentralDogmaConfig)Jackson.readValue((File)configFile, CentralDogmaConfig.class), securityConfig);
    }

    CentralDogma(CentralDogmaConfig cfg, @Nullable Ini securityConfig) {
        this.cfg = Objects.requireNonNull(cfg, "cfg");
        if (cfg.isSecurityEnabled()) {
            Objects.requireNonNull(securityConfig, "securityConfig (must be non-null if securityEnabled is true)");
            Ini iniCopy = new Ini();
            iniCopy.putAll((Map)securityConfig);
            this.securityConfig = iniCopy;
        } else {
            this.securityConfig = null;
        }
    }

    public Optional<ServerPort> activePort() {
        Server server = this.server;
        return server != null ? server.activePort() : Optional.empty();
    }

    public Map<InetSocketAddress, ServerPort> activePorts() {
        Server server = this.server;
        if (server != null) {
            return server.activePorts();
        }
        return Collections.emptyMap();
    }

    public Optional<MirroringService> mirroringService() {
        return Optional.ofNullable(this.mirroringService);
    }

    public Optional<CacheStats> cacheStats() {
        ProjectManager pm = this.pm;
        if (pm == null) {
            return Optional.empty();
        }
        return Optional.of(pm.cacheStats());
    }

    public CompletableFuture<Void> start() {
        return this.startStop.start(true);
    }

    public CompletableFuture<Void> stop() {
        this.numPendingStopRequests.incrementAndGet();
        return this.startStop.stop().thenRun(this.numPendingStopRequests::decrementAndGet);
    }

    @Override
    public void close() {
        this.startStop.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() {
        Server server;
        CommandExecutor executor;
        DefaultMirroringService mirroringService;
        DefaultProjectManager pm;
        ThreadPoolExecutor repositoryWorker;
        block7: {
            boolean success = false;
            repositoryWorker = null;
            pm = null;
            mirroringService = null;
            executor = null;
            server = null;
            CentralDogmaSecurityManager securityManager = null;
            try {
                logger.info("Starting the Central Dogma ..");
                repositoryWorker = new ThreadPoolExecutor(this.cfg.numRepositoryWorkers(), this.cfg.numRepositoryWorkers(), 60L, TimeUnit.SECONDS, new LinkedTransferQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory("repository-worker", true));
                repositoryWorker.allowCoreThreadTimeOut(true);
                logger.info("Starting the project manager: {}", (Object)this.cfg.dataDir());
                pm = new DefaultProjectManager(this.cfg.dataDir(), repositoryWorker, this.cfg.repositoryCacheSpec());
                logger.info("Started the project manager: {}", (Object)pm);
                logger.info("Current settings:\n{}", (Object)this.cfg);
                mirroringService = new DefaultMirroringService(new File(this.cfg.dataDir(), "_mirrors"), pm, this.cfg.numMirroringThreads(), this.cfg.maxNumFilesPerMirror(), this.cfg.maxNumBytesPerMirror());
                if (this.cfg.isSecurityEnabled()) {
                    assert (this.securityConfig != null);
                    securityManager = new CentralDogmaSecurityManager(this.cfg.dataDir(), this.securityConfig, this.cfg.webAppSessionTimeoutMillis(), this.cfg.sessionCacheSpec());
                }
                logger.info("Starting the command executor ..");
                executor = this.startCommandExecutor(pm, mirroringService, repositoryWorker, securityManager);
                if (executor.isWritable()) {
                    logger.info("Started the command executor");
                    ProjectInitializer.initializeInternalProject(executor);
                    MigrationUtil.migrate(pm, executor);
                }
                logger.info("Starting the RPC server");
                server = this.startServer(pm, executor, securityManager);
                logger.info("Started the RPC server at: {}", (Object)server.activePorts());
                logger.info("Started the Central Dogma successfully");
                success = true;
                if (!success) break block7;
                this.repositoryWorker = repositoryWorker;
                this.pm = pm;
                this.executor = executor;
                this.mirroringService = mirroringService;
                this.server = server;
            }
            catch (Throwable throwable) {
                if (success) {
                    this.repositoryWorker = repositoryWorker;
                    this.pm = pm;
                    this.executor = executor;
                    this.mirroringService = mirroringService;
                    this.server = server;
                } else {
                    CentralDogma.doStop(server, executor, mirroringService, pm, repositoryWorker);
                }
                throw throwable;
            }
        }
        CentralDogma.doStop(server, executor, mirroringService, pm, repositoryWorker);
    }

    private CommandExecutor startCommandExecutor(ProjectManager pm, DefaultMirroringService mirroringService, Executor repositoryWorker, @Nullable CentralDogmaSecurityManager securityManager) {
        CommandExecutor executor;
        Consumer<CommandExecutor> onTakeLeadership = exec -> {
            if (this.cfg.isMirroringEnabled()) {
                logger.info("Starting the mirroring service ..");
                mirroringService.start((CommandExecutor)exec);
                logger.info("Started the mirroring service");
            } else {
                logger.info("Not starting the mirroring service because it's disabled.");
            }
            if (securityManager != null) {
                logger.info("Starting the periodic session validation ..");
                securityManager.enableSessionValidation();
                logger.info("Started the periodic session validation");
            }
        };
        Runnable onReleaseLeadership = () -> {
            if (this.cfg.isMirroringEnabled()) {
                logger.info("Stopping the mirroring service ..");
                mirroringService.stop();
                logger.info("Stopped the mirroring service");
            }
            if (securityManager != null) {
                logger.info("Stopping the periodic session validation ..");
                securityManager.disableSessionValidation();
                logger.info("Stopped the periodic session validation");
            }
        };
        ReplicationMethod replicationMethod = this.cfg.replicationConfig().method();
        switch (replicationMethod) {
            case ZOOKEEPER: {
                executor = this.newZooKeeperCommandExecutor(pm, repositoryWorker, securityManager, onTakeLeadership, onReleaseLeadership);
                break;
            }
            case NONE: {
                logger.info("No replication mechanism specified; entering standalone");
                executor = new StandaloneCommandExecutor(pm, securityManager, repositoryWorker, onTakeLeadership, onReleaseLeadership);
                break;
            }
            default: {
                throw new Error("unknown replication method: " + (Object)((Object)replicationMethod));
            }
        }
        try {
            CompletableFuture<Void> startFuture = executor.start();
            while (!startFuture.isDone()) {
                if (this.numPendingStopRequests.get() > 0) {
                    executor.stop().get();
                    break;
                }
                try {
                    startFuture.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {}
            }
            startFuture.get();
        }
        catch (Exception e) {
            logger.warn("Failed to start the command executor. Entering read-only.", (Throwable)e);
        }
        return executor;
    }

    private Server startServer(final ProjectManager pm, CommandExecutor executor, @Nullable CentralDogmaSecurityManager securityManager) {
        ServerBuilder sb = new ServerBuilder();
        this.cfg.ports().forEach(arg_0 -> ((ServerBuilder)sb).port(arg_0));
        if (this.cfg.ports().stream().anyMatch(ServerPort::hasTls)) {
            try {
                TlsConfig tlsConfig = this.cfg.tls();
                if (tlsConfig != null) {
                    sb.tls(tlsConfig.keyCertChainFile(), tlsConfig.keyFile(), tlsConfig.keyPassword());
                } else {
                    logger.warn("Missing TLS configuration. Generating a self-signed certificate for TLS support.");
                    sb.tlsSelfSigned();
                }
            }
            catch (Exception e) {
                Exceptions.throwUnsafely((Throwable)e);
            }
        }
        this.cfg.numWorkers().ifPresent(numWorkers -> sb.workerGroup(EventLoopGroups.newEventLoopGroup((int)numWorkers), true));
        this.cfg.maxNumConnections().ifPresent(arg_0 -> ((ServerBuilder)sb).maxNumConnections(arg_0));
        this.cfg.idleTimeoutMillis().ifPresent(arg_0 -> ((ServerBuilder)sb).idleTimeoutMillis(arg_0));
        this.cfg.requestTimeoutMillis().ifPresent(arg_0 -> ((ServerBuilder)sb).defaultRequestTimeoutMillis(arg_0));
        this.cfg.maxFrameLength().ifPresent(arg_0 -> ((ServerBuilder)sb).defaultMaxRequestLength(arg_0));
        this.cfg.gracefulShutdownTimeout().ifPresent(t -> sb.gracefulShutdownTimeout(t.quietPeriodMillis(), t.timeoutMillis()));
        WatchService watchService = new WatchService();
        MetadataService mds = new MetadataService(pm, executor);
        this.configureThriftService(sb, pm, executor, watchService, mds);
        sb.service("/hostname", (Service)HttpFileService.forVfs((HttpVfs)new AbstractHttpVfs(){

            public HttpVfs.Entry get(String path, @Nullable String contentEncoding) {
                Objects.requireNonNull(path, "path");
                return new HttpVfs.ByteArrayEntry(path, MediaType.PLAIN_TEXT_UTF_8, CentralDogma.this.server.defaultHostname().getBytes(StandardCharsets.UTF_8));
            }

            public String meterTag() {
                return "hostname";
            }
        }));
        sb.service("/cache_stats", (Service)new AbstractHttpService(){

            protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
                return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)Jackson.writeValueAsPrettyString((Object)pm.cacheStats()));
            }
        });
        sb.service("/monitor/l7check", (Service)new HttpHealthCheckService(new HealthChecker[0]));
        sb.service("/docs", (Service)new AbstractHttpService(){

            protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
                return HttpResponse.of((HttpHeaders)((HttpHeaders)HttpHeaders.of((HttpStatus)HttpStatus.TEMPORARY_REDIRECT).set((Object)HttpHeaderNames.LOCATION, (Object)"/docs/")));
            }
        });
        sb.serviceUnder("/docs/", (Service)new DocServiceBuilder().exampleHttpHeaders(CentralDogmaService.class, new HttpHeaders[]{HttpHeaders.of((AsciiString)HttpHeaderNames.AUTHORIZATION, (String)"bearer anonymous")}).build());
        this.configureHttpApi(sb, pm, executor, watchService, mds, securityManager);
        String accessLogFormat = this.cfg.accessLogFormat();
        if (Strings.isNullOrEmpty((String)accessLogFormat)) {
            sb.accessLogWriter(AccessLogWriter.disabled(), true);
        } else if ("common".equals(accessLogFormat)) {
            sb.accessLogWriter(AccessLogWriter.common(), true);
        } else if ("combined".equals(accessLogFormat)) {
            sb.accessLogWriter(AccessLogWriter.combined(), true);
        } else {
            sb.accessLogFormat(accessLogFormat);
        }
        Server s = sb.build();
        s.start().join();
        return s;
    }

    private CommandExecutor newZooKeeperCommandExecutor(ProjectManager pm, Executor repositoryWorker, @Nullable CentralDogmaSecurityManager securityManager, @Nullable Consumer<CommandExecutor> onTakeLeadership, @Nullable Runnable onReleaseLeadership) {
        ZooKeeperReplicationConfig zkCfg = (ZooKeeperReplicationConfig)this.cfg.replicationConfig();
        new File(this.cfg.dataDir(), "replica_id").delete();
        return new ZooKeeperCommandExecutor(zkCfg, this.cfg.dataDir(), new StandaloneCommandExecutor(pm, securityManager, repositoryWorker, null, null), onTakeLeadership, onReleaseLeadership);
    }

    private void configureThriftService(ServerBuilder sb, ProjectManager pm, CommandExecutor executor, WatchService watchService, MetadataService mds) {
        CentralDogmaServiceImpl service = new CentralDogmaServiceImpl(pm, executor, watchService, mds);
        Service thriftService = ((CentralDogmaExceptionTranslator)((CentralDogmaTimeoutScheduler)ThriftCallService.of((Object)service).decorate(CentralDogmaTimeoutScheduler::new)).decorate(CentralDogmaExceptionTranslator::new)).decorate(THttpService.newDecorator());
        thriftService = this.cfg.isCsrfTokenRequiredForThrift() ? thriftService.decorate(HttpAuthService.newDecorator((Authorizer[])new Authorizer[]{new CsrfTokenAuthorizer()})) : thriftService.decorate(TokenlessClientLogger::new);
        thriftService = thriftService.decorate(CentralDogma.contentEncodingDecorator());
        sb.service("/cd/thrift/v1", thriftService);
    }

    private void configureHttpApi(ServerBuilder sb, ProjectManager pm, CommandExecutor executor, WatchService watchService, MetadataService mds, @Nullable CentralDogmaSecurityManager securityManager) {
        Function<Service<HttpRequest, HttpResponse>, HttpEncodingService> decorator;
        Object logoutService;
        Object loginService;
        Function<String, String> loginNameNormalizer;
        String apiV0PathPrefix = "/api/v0/";
        Function<Object, Object> function = loginNameNormalizer = this.cfg.caseSensitiveLoginNames() ? Function.identity() : Ascii::toLowerCase;
        if (this.cfg.isSecurityEnabled()) {
            Objects.requireNonNull(securityManager, "securityManager");
            Cache sessionCache = Caffeine.from((String)RepositoryCache.validateCacheSpec(this.cfg.sessionCacheSpec())).build();
            loginService = new LoginService(securityManager, executor, loginNameNormalizer, (Cache<String, AccessToken>)sessionCache);
            logoutService = new LogoutService(securityManager, executor, (Cache<String, AccessToken>)sessionCache);
            sb.service("/security_enabled", (Service)new AbstractHttpService(){

                protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) {
                    return HttpResponse.of((HttpStatus)HttpStatus.OK);
                }
            });
            ApplicationTokenAuthorizer ata = new ApplicationTokenAuthorizer(mds::findTokenBySecret);
            SessionTokenAuthorizer sta = new SessionTokenAuthorizer(securityManager, this.cfg.administrators());
            decorator = MetadataServiceInjector.newDecorator(mds).andThen(HttpAuthService.newDecorator((Authorizer[])new Authorizer[]{ata, sta}));
        } else {
            loginService = (ctx, req) -> {
                AccessToken accessToken = new AccessToken("anonymous", Integer.MAX_VALUE);
                return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (byte[])Jackson.writeValueAsBytes((Object)accessToken));
            };
            logoutService = (ctx, req) -> HttpResponse.of((HttpStatus)HttpStatus.OK);
            decorator = MetadataServiceInjector.newDecorator(mds).andThen(HttpAuthService.newDecorator((Authorizer[])new Authorizer[]{new CsrfTokenAuthorizer()}));
        }
        sb.service("/api/v0/authenticate", loginService).service("/api/v1/login", loginService).service("/api/v0/logout", logoutService).service("/api/v1/logout", logoutService);
        SafeProjectManager safePm = new SafeProjectManager(pm);
        HttpApiRequestConverter v1RequestConverter = new HttpApiRequestConverter(safePm);
        HttpApiResponseConverter v1ResponseConverter = new HttpApiResponseConverter();
        decorator = decorator.andThen(CentralDogma.contentEncodingDecorator());
        sb.annotatedService("/api/v1/", (Object)new AdministrativeService(safePm, executor), decorator, new Object[]{v1RequestConverter, v1ResponseConverter});
        sb.annotatedService("/api/v1/", (Object)new ProjectServiceV1(safePm, executor, mds), decorator, new Object[]{v1RequestConverter, v1ResponseConverter});
        sb.annotatedService("/api/v1/", (Object)new RepositoryServiceV1(safePm, executor, mds), decorator, new Object[]{v1RequestConverter, v1ResponseConverter});
        sb.annotatedService("/api/v1/", (Object)new ContentServiceV1(safePm, executor, watchService), decorator, new Object[]{v1RequestConverter, v1ResponseConverter});
        if (this.cfg.isSecurityEnabled()) {
            sb.annotatedService("/api/v1/", (Object)new MetadataApiService(mds, loginNameNormalizer), decorator, new Object[]{v1RequestConverter, v1ResponseConverter});
            sb.annotatedService("/api/v1/", (Object)new TokenService(pm, executor, mds), decorator, new Object[]{v1RequestConverter, v1ResponseConverter});
        }
        if (this.cfg.isWebAppEnabled()) {
            RestfulJsonResponseConverter httpApiV0Converter = new RestfulJsonResponseConverter();
            sb.annotatedService("/api/v0/", (Object)new UserService(safePm, executor), decorator, new Object[]{httpApiV0Converter}).annotatedService("/api/v0/", (Object)new RepositoryService(safePm, executor), decorator, new Object[]{httpApiV0Converter});
        }
        sb.serviceUnder("/", (Service)HttpFileService.forClassPath((String)"webapp"));
    }

    private static Function<Service<HttpRequest, HttpResponse>, HttpEncodingService> contentEncodingDecorator() {
        return delegate -> new HttpEncodingService(delegate, contentType -> {
            if ("application".equals(contentType.type())) {
                String subtype;
                switch (subtype = contentType.subtype()) {
                    case "json": 
                    case "xml": 
                    case "x-thrift": {
                        return true;
                    }
                }
                return subtype.endsWith("+json") || subtype.endsWith("+xml") || subtype.startsWith("vnd.apache.thrift.");
            }
            return false;
        }, 1024);
    }

    private void doStop() {
        if (this.server == null) {
            return;
        }
        Server server = this.server;
        CommandExecutor executor = this.executor;
        DefaultMirroringService mirroringService = this.mirroringService;
        ProjectManager pm = this.pm;
        ExecutorService repositoryWorker = this.repositoryWorker;
        this.server = null;
        this.executor = null;
        this.mirroringService = null;
        this.pm = null;
        this.repositoryWorker = null;
        logger.info("Stopping the Central Dogma ..");
        if (!CentralDogma.doStop(server, executor, mirroringService, pm, repositoryWorker)) {
            logger.warn("Stopped the Central Dogma with failure");
        } else {
            logger.info("Stopped the Central Dogma successfully");
        }
    }

    private static boolean doStop(@Nullable Server server, @Nullable CommandExecutor executor, @Nullable DefaultMirroringService mirroringService, @Nullable ProjectManager pm, @Nullable ExecutorService repositoryWorker) {
        boolean success = true;
        try {
            if (pm != null) {
                logger.info("Stopping the project manager ..");
                pm.close(ShuttingDownException::new);
                logger.info("Stopped the project manager");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the project manager:", t);
        }
        try {
            if (executor != null) {
                logger.info("Stopping the command executor ..");
                executor.stop();
                logger.info("Stopped the command executor");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the command executor:", t);
        }
        try {
            if (mirroringService != null && mirroringService.isStarted()) {
                logger.info("Stopping the mirroring service not terminated by the command executor ..");
                mirroringService.stop();
                logger.info("Stopped the mirroring service");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the mirroring service:", t);
        }
        try {
            if (repositoryWorker != null && !repositoryWorker.isTerminated()) {
                logger.info("Stopping the repository worker ..");
                boolean interruptLater = false;
                while (!repositoryWorker.isTerminated()) {
                    repositoryWorker.shutdownNow();
                    try {
                        repositoryWorker.awaitTermination(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        interruptLater = true;
                    }
                }
                logger.info("Stopped the repository worker");
                if (interruptLater) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the repository worker:", t);
        }
        try {
            if (server != null) {
                logger.info("Stopping the RPC server ..");
                server.stop().join();
                logger.info("Stopped the RPC server");
            }
        }
        catch (Throwable t) {
            success = false;
            logger.warn("Failed to stop the RPC server:", t);
        }
        return success;
    }

    static {
        Jackson.registerModules((Module[])new Module[]{new SimpleModule().addSerializer(CacheStats.class, (JsonSerializer)new CacheStatsSerializer())});
    }

    private final class CentralDogmaStartStop
    extends StartStopSupport<Void, Void> {
        CentralDogmaStartStop() {
            super((Executor)GlobalEventExecutor.INSTANCE);
        }

        protected CompletionStage<Void> doStart() throws Exception {
            return this.execute("startup", () -> CentralDogma.this.doStart());
        }

        protected CompletionStage<Void> doStop() throws Exception {
            return this.execute("shutdown", () -> CentralDogma.this.doStop());
        }

        private CompletionStage<Void> execute(String mode, Runnable task) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            Thread thread = new Thread(() -> {
                try {
                    task.run();
                    future.complete(null);
                }
                catch (Throwable cause) {
                    future.completeExceptionally(cause);
                }
            }, "dogma-" + mode + "-0x" + Long.toHexString((long)CentralDogma.this.hashCode() & 0xFFFFFFFFL));
            thread.start();
            return future;
        }
    }
}

