/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.support.shiro;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.io.SerializationException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedSessionDAO
implements SessionDAO,
CacheManagerAware {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedSessionDAO.class);
    private static final String CACHE_NAME = FileBasedSessionDAO.class.getSimpleName();
    private static final Supplier<String> nextSessionId = () -> UUID.randomUUID().toString();
    private static final int SESSION_ID_LENGTH = nextSessionId.get().length();
    private static final int SESSION_ID_1ST_PART_LENGTH = 2;
    private static final Pattern SESSION_ID_1ST_PART_PATTERN = Pattern.compile("^[0-9a-f]{2}$");
    private static final int SESSION_ID_2ND_PART_LENGTH = SESSION_ID_LENGTH - 2;
    private static final Pattern SESSION_ID_2ND_PART_PATTERN = Pattern.compile("^[-0-9a-f]{" + SESSION_ID_2ND_PART_LENGTH + "}$");
    private static final Pattern SESSION_ID_PATTERN = Pattern.compile("^[-0-9a-f]{" + SESSION_ID_LENGTH + "}$");
    private final Path rootDir;
    private final Path tmpDir;
    @Nullable
    @VisibleForTesting
    Cache<String, SimpleSession> cache;

    public FileBasedSessionDAO(Path rootDir) throws IOException {
        Objects.requireNonNull(rootDir, "rootDir");
        this.rootDir = rootDir;
        this.tmpDir = rootDir.resolve("tmp");
        Files.createDirectories(this.tmpDir, new FileAttribute[0]);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cache = Objects.requireNonNull(cacheManager, "cacheManager").getCache(CACHE_NAME);
    }

    public boolean exists(String sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        SimpleSession cachedSession = this.getFromCache(sessionId);
        if (cachedSession != null) {
            return true;
        }
        return Files.isRegularFile(this.sessionId2Path(sessionId), new LinkOption[0]);
    }

    public Serializable create(Session session) {
        SimpleSession simpleSession = FileBasedSessionDAO.ensureSimpleSession(session);
        boolean generateSessionId = simpleSession.getId() == null;
        while (true) {
            String sessionId = generateSessionId ? nextSessionId.get() : FileBasedSessionDAO.ensureStringSessionId(session);
            Path newPath = this.sessionId2Path(sessionId);
            boolean success = false;
            try {
                try {
                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException e) {
                    throw new SerializationException((Throwable)e);
                }
                Path tmpPath = Files.createTempFile(this.tmpDir, null, null, new FileAttribute[0]);
                simpleSession.setId((Serializable)((Object)sessionId));
                Files.write(tmpPath, FileBasedSessionDAO.serialize((Session)simpleSession), new OpenOption[0]);
                Files.move(tmpPath, newPath, StandardCopyOption.ATOMIC_MOVE);
                this.updateCache(sessionId, simpleSession);
                success = true;
                String string = sessionId;
                return string;
            }
            catch (FileAlreadyExistsException unused) {
                if (generateSessionId) continue;
                throw new SerializationException("duplicate session: " + sessionId);
            }
            catch (IOException e) {
                throw new SerializationException((Throwable)e);
            }
            finally {
                if (success) continue;
                simpleSession.setId(null);
                continue;
            }
            break;
        }
    }

    public SimpleSession readSession(Serializable sessionIdObj) {
        String sessionId = FileBasedSessionDAO.ensureStringSessionId(sessionIdObj);
        SimpleSession cachedSession = this.getFromCache(sessionId);
        if (cachedSession != null) {
            return cachedSession;
        }
        try {
            SimpleSession session = this.uncachedRead(sessionId);
            this.updateCache(sessionId, session);
            return session;
        }
        catch (FileNotFoundException | NoSuchFileException unused) {
            throw new UnknownSessionException(sessionId);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    @VisibleForTesting
    SimpleSession uncachedRead(String sessionId) throws IOException, ClassNotFoundException {
        return FileBasedSessionDAO.deserialize(Files.readAllBytes(this.sessionId2Path(sessionId)));
    }

    public void update(Session session) {
        String sessionId = FileBasedSessionDAO.ensureStringSessionId(session);
        Path oldPath = this.sessionId2Path(sessionId);
        if (!Files.exists(oldPath, new LinkOption[0])) {
            throw new UnknownSessionException(sessionId);
        }
        try {
            Path newPath = Files.createTempFile(this.tmpDir, null, null, new FileAttribute[0]);
            Files.write(newPath, FileBasedSessionDAO.serialize(session), new OpenOption[0]);
            Files.move(newPath, oldPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void delete(Session session) {
        String sessionId = FileBasedSessionDAO.ensureStringSessionId(session);
        this.delete(sessionId);
    }

    public void delete(String sessionId) {
        try {
            Files.delete(this.sessionId2Path(sessionId));
            this.deleteFromCache(sessionId);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Nullable
    private SimpleSession getFromCache(String sessionId) {
        Cache<String, SimpleSession> cache = this.cache;
        return cache != null ? (SimpleSession)cache.get((Object)sessionId) : null;
    }

    private void updateCache(String sessionId, SimpleSession session) {
        Cache<String, SimpleSession> cache = this.cache;
        if (cache != null) {
            cache.put((Object)sessionId, (Object)session);
        }
    }

    private void deleteFromCache(String sessionId) {
        Cache<String, SimpleSession> cache = this.cache;
        if (cache != null) {
            cache.remove((Object)sessionId);
        }
    }

    public Collection<Session> getActiveSessions() {
        return new AbstractCollection<Session>(){

            @Override
            public Iterator<Session> iterator() {
                Stream<Path> stream;
                try {
                    stream = Files.walk(FileBasedSessionDAO.this.rootDir, 2, new FileVisitOption[0]);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
                return stream.map(path -> {
                    if (!FileBasedSessionDAO.isSessionFile(path)) {
                        return null;
                    }
                    try {
                        return FileBasedSessionDAO.deserialize(Files.readAllBytes(path));
                    }
                    catch (FileNotFoundException | NoSuchFileException iOException) {
                    }
                    catch (Exception e) {
                        logger.warn("Failed to deserialize a session: {}", path, (Object)e);
                    }
                    return null;
                }).filter(Objects::nonNull).iterator();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Path sessionId2Path(String sessionId) {
        return this.rootDir.resolve(sessionId.substring(0, 2)).resolve(sessionId.substring(2));
    }

    private static boolean isSessionFile(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        int nameCount = path.getNameCount();
        if (nameCount < 2) {
            return false;
        }
        String first = path.getName(nameCount - 2).toString();
        if (!SESSION_ID_1ST_PART_PATTERN.matcher(first).matches()) {
            return false;
        }
        String second = path.getName(nameCount - 1).toString();
        return SESSION_ID_2ND_PART_PATTERN.matcher(second).matches();
    }

    private static SimpleSession ensureSimpleSession(Session session) {
        Objects.requireNonNull(session, "session");
        Preconditions.checkArgument((boolean)(session instanceof SimpleSession), (String)"session: %s (expected: SimpleSession)", (Object)session);
        return (SimpleSession)session;
    }

    private static String ensureStringSessionId(Session session) {
        return FileBasedSessionDAO.ensureStringSessionId(Objects.requireNonNull(session, "session").getId());
    }

    private static String ensureStringSessionId(Serializable sessionId) {
        Objects.requireNonNull(sessionId, "sessionId");
        Preconditions.checkArgument((boolean)(sessionId instanceof String), (String)"sessionId: %s (expected: String)", (Object)sessionId);
        Preconditions.checkArgument((boolean)SESSION_ID_PATTERN.matcher((CharSequence)((Object)sessionId)).matches(), (String)"sessionId: %s (expected: UUID)", (Object)sessionId);
        return (String)((Object)sessionId);
    }

    /*
     * Exception decompiling
     */
    static byte[] serialize(Session session) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    static SimpleSession deserialize(byte[] encoded) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

