/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.thrift;

import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.centraldogma.common.ChangeConflictException;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.QueryExecutionException;
import com.linecorp.centraldogma.common.RedundantChangeException;
import com.linecorp.centraldogma.common.RepositoryExistsException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.RevisionNotFoundException;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.thrift.Author;
import com.linecorp.centraldogma.internal.thrift.AuthorConverter;
import com.linecorp.centraldogma.internal.thrift.CentralDogmaException;
import com.linecorp.centraldogma.internal.thrift.Change;
import com.linecorp.centraldogma.internal.thrift.ChangeConverter;
import com.linecorp.centraldogma.internal.thrift.ChangeType;
import com.linecorp.centraldogma.internal.thrift.Commit;
import com.linecorp.centraldogma.internal.thrift.CommitConverter;
import com.linecorp.centraldogma.internal.thrift.EntryConverter;
import com.linecorp.centraldogma.internal.thrift.ErrorCode;
import com.linecorp.centraldogma.internal.thrift.Markup;
import com.linecorp.centraldogma.internal.thrift.MarkupConverter;
import com.linecorp.centraldogma.internal.thrift.Project;
import com.linecorp.centraldogma.internal.thrift.Query;
import com.linecorp.centraldogma.internal.thrift.QueryConverter;
import com.linecorp.centraldogma.internal.thrift.Repository;
import com.linecorp.centraldogma.internal.thrift.RevisionConverter;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class Converter {
    @Nullable
    static <T, U> List<T> convert(@Nullable Collection<U> list, Function<U, T> mapper) {
        if (list == null) {
            return null;
        }
        return list.stream().map(mapper).collect(Collectors.toList());
    }

    static com.linecorp.centraldogma.internal.thrift.Revision convert(Revision rev) {
        return (com.linecorp.centraldogma.internal.thrift.Revision)RevisionConverter.TO_DATA.convert((Object)rev);
    }

    static Revision convert(com.linecorp.centraldogma.internal.thrift.Revision rev) {
        return (Revision)RevisionConverter.TO_MODEL.convert((Object)rev);
    }

    static Author convert(com.linecorp.centraldogma.common.Author author) {
        return (Author)AuthorConverter.TO_DATA.convert((Object)author);
    }

    static com.linecorp.centraldogma.common.Author convert(Author author) {
        return (com.linecorp.centraldogma.common.Author)AuthorConverter.TO_MODEL.convert((Object)author);
    }

    static com.linecorp.centraldogma.common.Change<?> convert(Change c) {
        return (com.linecorp.centraldogma.common.Change)ChangeConverter.TO_MODEL.convert((Object)c);
    }

    static Change convert(com.linecorp.centraldogma.common.Change<?> c) {
        return (Change)ChangeConverter.TO_DATA.convert(c);
    }

    static <T> com.linecorp.centraldogma.common.Query<T> convert(Query query) {
        return (com.linecorp.centraldogma.common.Query)QueryConverter.TO_MODEL.convert((Object)query);
    }

    static Query convert(com.linecorp.centraldogma.common.Query<?> query) {
        return (Query)QueryConverter.TO_DATA.convert(query);
    }

    static Markup convert(com.linecorp.centraldogma.common.Markup markup) {
        return (Markup)MarkupConverter.TO_DATA.convert((Object)markup);
    }

    static com.linecorp.centraldogma.common.Markup convert(Markup markup) {
        return (com.linecorp.centraldogma.common.Markup)MarkupConverter.TO_MODEL.convert((Object)markup);
    }

    static com.linecorp.centraldogma.internal.thrift.EntryType convert(EntryType type) {
        return EntryConverter.convertEntryType((EntryType)type);
    }

    @Nullable
    static ChangeType convert(@Nullable com.linecorp.centraldogma.common.ChangeType type) {
        if (type == null) {
            return null;
        }
        return ChangeType.valueOf((String)type.name());
    }

    static com.linecorp.centraldogma.internal.thrift.Entry convert(Entry<?> entry) {
        return EntryConverter.convert(entry);
    }

    static Project convert(String name, com.linecorp.centraldogma.server.internal.storage.project.Project project) {
        return new Project(name);
    }

    static CompletableFuture<Repository> convert(String name, com.linecorp.centraldogma.server.internal.storage.repository.Repository repo) {
        return repo.history(Revision.HEAD, Revision.HEAD, "/**", 1).thenApply(history -> new Repository(name).setHead(Converter.convert((com.linecorp.centraldogma.common.Commit)history.get(0))));
    }

    static Commit convert(com.linecorp.centraldogma.common.Commit commit) {
        return (Commit)CommitConverter.TO_DATA.convert((Object)commit);
    }

    static com.linecorp.centraldogma.common.Commit convert(Commit commit) {
        return (com.linecorp.centraldogma.common.Commit)CommitConverter.TO_MODEL.convert((Object)commit);
    }

    static CentralDogmaException convert(Throwable t) {
        if ((t = Exceptions.peel((Throwable)t)) instanceof CentralDogmaException) {
            return (CentralDogmaException)t;
        }
        ErrorCode code = ErrorCode.INTERNAL_SERVER_ERROR;
        if (t instanceof IllegalArgumentException) {
            code = ErrorCode.BAD_REQUEST;
        } else if (t instanceof EntryNotFoundException) {
            code = ErrorCode.ENTRY_NOT_FOUND;
        } else if (t instanceof RevisionNotFoundException) {
            code = ErrorCode.REVISION_NOT_FOUND;
        } else if (t instanceof QueryExecutionException) {
            code = ErrorCode.QUERY_FAILURE;
        } else if (t instanceof RedundantChangeException) {
            code = ErrorCode.REDUNDANT_CHANGE;
        } else if (t instanceof ChangeConflictException) {
            code = ErrorCode.CHANGE_CONFLICT;
        } else if (t instanceof ProjectNotFoundException) {
            code = ErrorCode.PROJECT_NOT_FOUND;
        } else if (t instanceof ProjectExistsException) {
            code = ErrorCode.PROJECT_EXISTS;
        } else if (t instanceof RepositoryNotFoundException) {
            code = ErrorCode.REPOSITORY_NOT_FOUND;
        } else if (t instanceof RepositoryExistsException) {
            code = ErrorCode.REPOSITORY_EXISTS;
        } else if (t instanceof ShuttingDownException) {
            code = ErrorCode.SHUTTING_DOWN;
        }
        CentralDogmaException cde = new CentralDogmaException(code);
        cde.setMessage(t.toString());
        cde.initCause(t);
        return cde;
    }

    private Converter() {
    }
}

