/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.repository.cache;

import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class CacheableCall<T> {
    final Repository repo;

    CacheableCall(Repository repo) {
        this.repo = Objects.requireNonNull(repo, "repo");
    }

    abstract int weigh(T var1);

    abstract CompletableFuture<T> execute();

    public int hashCode() {
        return System.identityHashCode(this.repo);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheableCall that = (CacheableCall)obj;
        return this.repo == that.repo;
    }

    public final String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("repo", (Object)(this.repo.parent().name() + '/' + this.repo.name()));
        this.toString(helper);
        return helper.toString();
    }

    abstract void toString(MoreObjects.ToStringHelper var1);
}

