/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.storage.project;

import com.linecorp.centraldogma.common.ProjectExistsException;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.plugin.PluginManager;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.DefaultMetaRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import com.linecorp.centraldogma.server.internal.storage.repository.RepositoryManager;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.CachingRepositoryManager;
import com.linecorp.centraldogma.server.internal.storage.repository.cache.RepositoryCache;
import com.linecorp.centraldogma.server.internal.storage.repository.git.GitRepositoryManager;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

class DefaultProject
implements Project {
    private final String name;
    final RepositoryManager repos;
    private final AtomicReference<MetaRepository> metaRepo = new AtomicReference();
    private PluginManager plugins;

    DefaultProject(File rootDir, boolean create, Executor repositoryWorker, @Nullable RepositoryCache cache) {
        Objects.requireNonNull(rootDir, "rootDir");
        Objects.requireNonNull(repositoryWorker, "repositoryWorker");
        if (create) {
            if (rootDir.exists()) {
                throw new ProjectExistsException(rootDir.toString());
            }
        } else if (!rootDir.exists()) {
            throw new ProjectNotFoundException(rootDir.toString());
        }
        this.name = rootDir.getName();
        GitRepositoryManager gitRepos = new GitRepositoryManager(this, rootDir, repositoryWorker);
        this.repos = cache == null ? gitRepos : new CachingRepositoryManager((RepositoryManager)gitRepos, cache);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public MetaRepository metaRepo() {
        MetaRepository metaRepo = this.metaRepo.get();
        if (metaRepo != null) {
            return metaRepo;
        }
        metaRepo = new DefaultMetaRepository((Repository)this.repos.get("meta"));
        if (this.metaRepo.compareAndSet(null, metaRepo)) {
            return metaRepo;
        }
        return this.metaRepo.get();
    }

    @Override
    public RepositoryManager repos() {
        return this.repos;
    }

    @Override
    public synchronized PluginManager plugins() {
        if (this.plugins != null) {
            return this.plugins;
        }
        this.plugins = new PluginManager(this);
        return this.plugins;
    }

    public String toString() {
        return Util.simpleTypeName(this.getClass()) + '(' + this.repos + ')';
    }
}

