/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.plugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.server.internal.plugin.Plugin;
import com.linecorp.centraldogma.server.internal.plugin.PluginException;
import com.linecorp.centraldogma.server.internal.storage.project.Project;
import com.linecorp.centraldogma.server.internal.storage.repository.MetaRepository;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(PluginManager.class);
    private static final String PLUGINS_JSON = "/plugins.json";
    private static final String PLUGINS_FIELD = "plugins";
    private static final Plugin[] NO_PLUGINS = new Plugin[0];
    private final Project project;
    private volatile Plugin[] plugins;

    public PluginManager(Project project) {
        this.project = Objects.requireNonNull(project, "project");
        this.reload();
    }

    public Revision reload() {
        MetaRepository metaRepo = this.project.metaRepo();
        Revision revision = metaRepo.normalizeNow(Revision.HEAD);
        this.plugins = this.loadPlugins(metaRepo, revision);
        return revision;
    }

    private Plugin[] loadPlugins(Repository metaRepo, Revision revision) {
        logger.info("Loading plugins for project: {} (revision: {})", (Object)this.project.name(), (Object)revision.text());
        Entry<?> entry = metaRepo.getOrNull(revision, PLUGINS_JSON).join();
        if (entry == null) {
            logger.info("Project '{}' contains no plugins.", (Object)this.project.name());
            return NO_PLUGINS;
        }
        if (entry.type() != EntryType.JSON) {
            logger.warn("{} is not a JSON object ({}); ignoring.", (Object)PLUGINS_JSON, (Object)entry.type());
            return NO_PLUGINS;
        }
        JsonNode plugins = ((JsonNode)entry.content()).findValue(PLUGINS_FIELD);
        if (plugins == null) {
            logger.warn("{} does not have the '{}' field; ignoring.", (Object)PLUGINS_JSON, (Object)PLUGINS_FIELD);
            return NO_PLUGINS;
        }
        if (plugins.getNodeType() != JsonNodeType.ARRAY) {
            logger.warn("{} has the '{}' field, but it is not an array ({}); ignoring.", new Object[]{PLUGINS_JSON, PLUGINS_FIELD, plugins.getNodeType()});
            return NO_PLUGINS;
        }
        if (!PluginManager.toStream(plugins).allMatch(JsonNode::isTextual)) {
            logger.warn("{} has the '{}' field, but it contains a non-textual element; ignoring.", (Object)PLUGINS_JSON, (Object)PLUGINS_FIELD);
            return NO_PLUGINS;
        }
        List<Plugin> loadedPlugins = PluginManager.toStream(plugins).map(PluginManager::toPluginPath).filter(path -> PluginManager.isPlugin(metaRepo, revision, path)).map(path -> this.loadPlugin(revision, (String)path)).collect(Collectors.toList());
        logger.info("Loaded {} plugin(s) for project: {}", (Object)loadedPlugins.size(), (Object)this.project.name());
        return loadedPlugins.toArray(new Plugin[loadedPlugins.size()]);
    }

    private static Stream<JsonNode> toStream(JsonNode plugins) {
        return StreamSupport.stream(((Iterable)() -> ((JsonNode)plugins).elements()).spliterator(), false);
    }

    private static String toPluginPath(JsonNode pluginEntry) {
        String path = pluginEntry.textValue();
        if (path.charAt(0) != '/') {
            return '/' + path;
        }
        return path;
    }

    private static boolean isPlugin(Repository metaRepo, Revision revision, String path) {
        if (!path.endsWith(".js")) {
            logger.warn("{} does not have '.js' extension; ignoring.", (Object)path);
            return false;
        }
        Entry<?> e = metaRepo.getOrNull(revision, path).join();
        if (e == null) {
            logger.warn("{} does not exist; ignoring.", (Object)path);
            return false;
        }
        if (e.type() != EntryType.TEXT) {
            logger.warn("{} is not a text file; ignoring.", (Object)path);
            return false;
        }
        return true;
    }

    private Plugin loadPlugin(Revision revision, String path) {
        try {
            return new Plugin(this.project, revision, path);
        }
        catch (Exception e) {
            throw new PluginException("failed to load plugin '" + path + "' (revision: " + revision.text() + "): " + e, e);
        }
    }

    public Object invoke(String funcName, Object ... args) throws InterruptedException {
        Objects.requireNonNull(funcName, "funcName");
        for (Plugin p : this.plugins) {
            if (!p.hasFunction(funcName)) continue;
            return p.invoke(funcName, args);
        }
        throw new PluginException("unknown function: " + funcName);
    }
}

