/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror.credential;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.server.internal.mirror.credential.MirrorCredential;
import java.net.URI;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

abstract class AbstractMirrorCredential
implements MirrorCredential {
    private final Set<Pattern> hostnamePatterns;
    private final Set<String> hostnamePatternStrings;

    AbstractMirrorCredential(Iterable<Pattern> hostnamePatterns) {
        this.hostnamePatterns = AbstractMirrorCredential.validateHostnamePatterns(hostnamePatterns);
        this.hostnamePatternStrings = this.hostnamePatterns.stream().map(Pattern::pattern).collect(Collectors.toSet());
    }

    private static Set<Pattern> validateHostnamePatterns(Iterable<Pattern> hostnamePatterns) {
        ImmutableSet set = ImmutableSet.copyOf((Iterable)Util.requireNonNullElements(hostnamePatterns, (String)"hostnamePatterns"));
        if (set.isEmpty()) {
            throw new IllegalArgumentException("hostnamePatterns is empty.");
        }
        return set;
    }

    @Override
    public Set<Pattern> hostnamePatterns() {
        return this.hostnamePatterns;
    }

    @Override
    public boolean matches(URI uri) {
        Objects.requireNonNull(uri, "uri");
        String host = uri.getHost();
        return host != null && this.hostnamePatterns.stream().anyMatch(p -> p.matcher(host).matches());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMirrorCredential that = (AbstractMirrorCredential)o;
        return this.hostnamePatternStrings.equals(that.hostnamePatternStrings);
    }

    public int hashCode() {
        return this.hostnamePatternStrings.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("hostnamePatterns", this.hostnamePatterns);
        this.addProperties(helper);
        return helper.toString();
    }

    abstract void addProperties(MoreObjects.ToStringHelper var1);
}

