/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.mirror;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.time.ExecutionTime;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.server.MirrorException;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.mirror.CentralDogmaMirror;
import com.linecorp.centraldogma.server.internal.mirror.GitMirror;
import com.linecorp.centraldogma.server.internal.mirror.MirrorDirection;
import com.linecorp.centraldogma.server.internal.mirror.credential.MirrorCredential;
import com.linecorp.centraldogma.server.internal.storage.repository.Repository;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class Mirror {
    protected static final Author MIRROR_AUTHOR = new Author("Mirror", "mirror@localhost.localdomain");
    private static final Pattern DOGMA_PATH_PATTERN = Pattern.compile("^/([^/]+)/([^/]+)\\.dogma$");
    private static final String SCHEME_DOGMA = "dogma";
    static final String SCHEME_GIT = "git";
    static final String SCHEME_GIT_SSH = "git+ssh";
    static final String SCHEME_GIT_HTTP = "git+http";
    static final String SCHEME_GIT_HTTPS = "git+https";
    static final String SCHEME_GIT_FILE = "git+file";
    private final Cron schedule;
    private final MirrorDirection direction;
    private final MirrorCredential credential;
    private final Repository localRepo;
    private final String localPath;
    private final URI remoteRepoUri;
    private final String remotePath;
    private final String remoteBranch;
    private final ExecutionTime executionTime;
    private final long jitterMillis;

    public static Mirror of(Cron schedule, MirrorDirection direction, MirrorCredential credential, Repository localRepo, String localPath, URI remoteUri) {
        String scheme = remoteUri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("no scheme in remoteUri: " + remoteUri);
        }
        switch (scheme) {
            case "dogma": {
                String[] components = Mirror.split(remoteUri, SCHEME_DOGMA, null);
                URI remoteRepoUri = URI.create(components[0]);
                Matcher matcher = DOGMA_PATH_PATTERN.matcher(remoteRepoUri.getPath());
                if (!matcher.find()) {
                    throw new IllegalArgumentException("cannot determine project name and repository name: " + remoteUri + " (expected: dogma://<host>[:<port>]/<project>/<repository>.dogma[<remotePath>])");
                }
                String remoteProject = matcher.group(1);
                String remoteRepo = matcher.group(2);
                return new CentralDogmaMirror(schedule, direction, credential, localRepo, localPath, remoteRepoUri, remoteProject, remoteRepo, components[1]);
            }
            case "git": 
            case "git+ssh": 
            case "git+http": 
            case "git+https": 
            case "git+file": {
                String[] components = Mirror.split(remoteUri, SCHEME_GIT, "master");
                return new GitMirror(schedule, direction, credential, localRepo, localPath, URI.create(components[0]), components[1], components[2]);
            }
        }
        throw new IllegalArgumentException("unsupported scheme in remoteUri: " + remoteUri);
    }

    private static String[] split(URI remoteUri, String suffix, @Nullable String defaultBranch) {
        String remotePath;
        String host = remoteUri.getHost();
        if (host == null && !remoteUri.getScheme().endsWith("+file")) {
            throw new IllegalArgumentException("no host in remoteUri: " + remoteUri);
        }
        String path = remoteUri.getRawPath();
        if (path == null) {
            throw new IllegalArgumentException("no path in remoteUri: " + remoteUri);
        }
        Matcher matcher = Pattern.compile("^(.*?\\." + suffix + ")(?:$|/)").matcher(path);
        if (!matcher.find()) {
            throw new IllegalArgumentException("no '." + suffix + "' in remoteUri path: " + remoteUri);
        }
        int port = remoteUri.getPort();
        String newRemoteUri = host != null ? (port > 0 ? remoteUri.getScheme() + "://" + host + ':' + port + matcher.group(1) : remoteUri.getScheme() + "://" + host + matcher.group(1)) : remoteUri.getScheme() + "://" + matcher.group(1);
        try {
            String decoded = URLDecoder.decode(path.substring(matcher.group(1).length()), "UTF-8");
            remotePath = decoded = Mirror.normalizePath(decoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        String fragment = remoteUri.getFragment();
        String remoteBranch = fragment != null ? fragment : defaultBranch;
        return new String[]{newRemoteUri, remotePath, remoteBranch};
    }

    protected Mirror(Cron schedule, MirrorDirection direction, MirrorCredential credential, Repository localRepo, String localPath, URI remoteRepoUri, String remotePath, @Nullable String remoteBranch) {
        this.schedule = Objects.requireNonNull(schedule, "schedule");
        this.direction = Objects.requireNonNull(direction, "direction");
        this.credential = Objects.requireNonNull(credential, "credential");
        this.localRepo = Objects.requireNonNull(localRepo, "localRepo");
        this.localPath = Mirror.normalizePath(Objects.requireNonNull(localPath, "localPath"));
        this.remoteRepoUri = Objects.requireNonNull(remoteRepoUri, "remoteRepoUri");
        this.remotePath = Mirror.normalizePath(Objects.requireNonNull(remotePath, "remotePath"));
        this.remoteBranch = remoteBranch;
        this.executionTime = ExecutionTime.forCron((Cron)this.schedule);
        this.jitterMillis = Math.abs(Objects.hash(new Object[]{this.schedule.asString(), this.direction, this.localRepo.parent().name(), this.localRepo.name(), this.remoteRepoUri, this.remotePath, this.remoteBranch}) / 35791);
    }

    private static String normalizePath(String path) {
        if (path.isEmpty()) {
            return "/";
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.endsWith("/")) {
            path = path + '/';
        }
        return path.replaceAll("//+", "/");
    }

    @VisibleForTesting
    public final Cron schedule() {
        return this.schedule;
    }

    public final ZonedDateTime nextExecutionTime(ZonedDateTime lastExecutionTime) {
        return this.nextExecutionTime(lastExecutionTime, this.jitterMillis);
    }

    @VisibleForTesting
    ZonedDateTime nextExecutionTime(ZonedDateTime lastExecutionTime, long jitterMillis) {
        Objects.requireNonNull(lastExecutionTime, "lastExecutionTime");
        ZonedDateTime next = this.executionTime.nextExecution(lastExecutionTime.minus(jitterMillis, ChronoUnit.MILLIS));
        return next.plus(jitterMillis, ChronoUnit.MILLIS);
    }

    public MirrorDirection direction() {
        return this.direction;
    }

    public final MirrorCredential credential() {
        return this.credential;
    }

    public final Repository localRepo() {
        return this.localRepo;
    }

    public final String localPath() {
        return this.localPath;
    }

    public final URI remoteRepoUri() {
        return this.remoteRepoUri;
    }

    public final String remotePath() {
        return this.remotePath;
    }

    public final String remoteBranch() {
        return this.remoteBranch;
    }

    public final void mirror(File workDir, CommandExecutor executor, int maxNumFiles, long maxNumBytes) {
        try {
            switch (this.direction()) {
                case LOCAL_TO_REMOTE: {
                    this.mirrorLocalToRemote(workDir, maxNumFiles, maxNumBytes);
                    break;
                }
                case REMOTE_TO_LOCAL: {
                    this.mirrorRemoteToLocal(workDir, executor, maxNumFiles, maxNumBytes);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (MirrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MirrorException(e);
        }
    }

    protected abstract void mirrorLocalToRemote(File var1, int var2, long var3) throws Exception;

    protected abstract void mirrorRemoteToLocal(File var1, CommandExecutor var2, int var3, long var4) throws Exception;

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"").add("schedule", (Object)CronDescriptor.instance().describe(this.schedule)).add("direction", (Object)this.direction).add("localRepo", (Object)this.localRepo.name()).add("localPath", (Object)this.localPath).add("remoteRepo", (Object)this.remoteRepoUri).add("remotePath", (Object)this.remotePath);
        if (this.remoteBranch != null) {
            helper.add("remoteBranch", (Object)this.remoteBranch);
        }
        helper.add("credential", (Object)this.credential);
        return helper.toString();
    }
}

