/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.DecoratingServiceFunction;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.centraldogma.common.ProjectNotFoundException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.server.internal.admin.authentication.AuthenticationUtil;
import com.linecorp.centraldogma.server.internal.admin.authentication.User;
import com.linecorp.centraldogma.server.internal.metadata.MetadataService;
import com.linecorp.centraldogma.server.internal.metadata.MetadataServiceInjector;
import com.linecorp.centraldogma.server.internal.metadata.ProjectRole;
import java.util.concurrent.CompletionStage;

abstract class AbstractRoleCheckingDecorator
implements DecoratingServiceFunction<HttpRequest, HttpResponse> {
    AbstractRoleCheckingDecorator() {
    }

    public final HttpResponse serve(Service<HttpRequest, HttpResponse> delegate, ServiceRequestContext ctx, HttpRequest req) throws Exception {
        MetadataService mds = MetadataServiceInjector.getMetadataService(ctx);
        User user = AuthenticationUtil.currentUser(ctx);
        String projectName = ctx.pathParam("projectName");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"no project name is specified");
        try {
            return HttpResponse.from((CompletionStage)mds.findRole(projectName, user).handle((role, cause) -> {
                if (cause != null) {
                    return AbstractRoleCheckingDecorator.handleException(cause);
                }
                if (!this.isAccessAllowed(ctx, req, user, (ProjectRole)((Object)role))) {
                    throw HttpStatusException.of((HttpStatus)HttpStatus.FORBIDDEN);
                }
                try {
                    return (HttpResponse)delegate.serve(ctx, (Request)req);
                }
                catch (Exception e) {
                    return (HttpResponse)Exceptions.throwUnsafely((Throwable)e);
                }
            }));
        }
        catch (Throwable cause2) {
            return AbstractRoleCheckingDecorator.handleException(cause2);
        }
    }

    static HttpResponse handleException(Throwable cause) {
        if ((cause = Exceptions.peel((Throwable)cause)) instanceof RepositoryNotFoundException || cause instanceof ProjectNotFoundException) {
            return HttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND);
        }
        return (HttpResponse)Exceptions.throwUnsafely((Throwable)cause);
    }

    protected abstract boolean isAccessAllowed(ServiceRequestContext var1, HttpRequest var2, User var3, ProjectRole var4);
}

