/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.centraldogma.internal.Jackson;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class HttpApiUtil {
    static final JsonNode unremoveRequest = Jackson.valueToTree((Object)ImmutableList.of((Object)ImmutableMap.of((Object)"op", (Object)"replace", (Object)"path", (Object)"/status", (Object)"value", (Object)"active")));

    public static HttpResponseException newHttpResponseException(HttpStatus status, String message) {
        return HttpResponseException.of((HttpResponse)HttpApiUtil.newResponseWithErrorMessage(status, message));
    }

    public static HttpResponseException newHttpResponseException(HttpStatus status, JsonNode node) {
        return HttpResponseException.of((HttpResponse)HttpApiUtil.newResponseWithJson(status, node));
    }

    public static HttpResponse newResponseWithErrorMessage(HttpStatus status, String message) {
        Objects.requireNonNull(message, "message");
        return HttpApiUtil.newResponseWithJson(status, (JsonNode)JsonNodeFactory.instance.objectNode().put("message", message));
    }

    public static HttpResponse newResponseWithJson(HttpStatus status, JsonNode node) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(node, "node");
        try {
            return HttpResponse.of((HttpStatus)status, (MediaType)MediaType.JSON_UTF_8, (byte[])Jackson.writeValueAsBytes((Object)node));
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    static void checkUnremoveArgument(JsonNode node) {
        Preconditions.checkArgument((boolean)unremoveRequest.equals((Object)node), (Object)("Unsupported JSON patch: " + node + " (expected: " + unremoveRequest + ')'));
    }

    static void checkStatusArgument(String status) {
        Preconditions.checkArgument((boolean)"removed".equalsIgnoreCase(status), (Object)("invalid status: " + status + " (expected: removed)"));
    }

    static Void throwUnsafelyIfNonNull(@Nullable Object unused, @Nullable Throwable cause) {
        HttpApiUtil.throwUnsafelyIfNonNull(cause);
        return null;
    }

    static void throwUnsafelyIfNonNull(@Nullable Throwable cause) {
        if (cause != null) {
            Exceptions.throwUnsafely((Throwable)cause);
        }
    }

    static <T, U> BiFunction<? super T, Throwable, ? extends U> returnOrThrow(Supplier<? super U> supplier) {
        return (unused, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return supplier.get();
        };
    }

    static <T, U> BiFunction<? super T, Throwable, ? extends U> returnOrThrow(Function<? super T, ? extends U> function) {
        return (result, cause) -> {
            HttpApiUtil.throwUnsafelyIfNonNull(cause);
            return function.apply(result);
        };
    }

    private HttpApiUtil() {
    }
}

