/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.internal.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.annotation.ConsumeType;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.RequestObject;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatch;
import com.linecorp.centraldogma.internal.jsonpatch.JsonPatchException;
import com.linecorp.centraldogma.server.internal.api.AbstractService;
import com.linecorp.centraldogma.server.internal.api.auth.AdministratorsOnly;
import com.linecorp.centraldogma.server.internal.command.CommandExecutor;
import com.linecorp.centraldogma.server.internal.storage.project.ProjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdministrativeService
extends AbstractService {
    private static final Logger logger = LoggerFactory.getLogger(AdministrativeService.class);

    public AdministrativeService(ProjectManager projectManager, CommandExecutor executor) {
        super(projectManager, executor);
    }

    @Get(value="/status")
    public ServerStatus status() {
        return new ServerStatus(this.executor().isStarted());
    }

    @Patch(value="/status")
    @ConsumeType(value="application/json-patch+json")
    @Decorator(value=AdministratorsOnly.class)
    public ServerStatus updateStatus(@RequestObject JsonNode patch) throws Exception {
        JsonNode newValue;
        ServerStatus oldStatus = this.status();
        JsonNode oldValue = Jackson.valueToTree((Object)oldStatus);
        try {
            newValue = JsonPatch.fromJson((JsonNode)patch).apply(oldValue);
        }
        catch (JsonPatchException e) {
            return AdministrativeService.rejectStatusPatch(patch);
        }
        if (!newValue.isObject()) {
            return AdministrativeService.rejectStatusPatch(patch);
        }
        JsonNode writableNode = newValue.get("writable");
        if (!writableNode.isBoolean()) {
            return AdministrativeService.rejectStatusPatch(patch);
        }
        if (writableNode.asBoolean()) {
            if (!oldStatus.writable) {
                throw HttpStatusException.of((HttpStatus)HttpStatus.NOT_IMPLEMENTED);
            }
        } else if (oldStatus.writable) {
            logger.warn("Entering read-only mode ..");
            this.executor().stop();
            logger.info("Entered read-only mode");
            return this.status();
        }
        throw HttpStatusException.of((HttpStatus)HttpStatus.NOT_MODIFIED);
    }

    private static ServerStatus rejectStatusPatch(JsonNode patch) {
        throw new IllegalArgumentException("Invalid JSON patch: " + patch);
    }

    private static final class ServerStatus {
        @JsonProperty
        final boolean writable;

        ServerStatus(boolean writable) {
            this.writable = writable;
        }
    }
}

