/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth.saml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.server.saml.KeyStoreCredentialResolverBuilder;
import com.linecorp.armeria.server.saml.SamlServiceProvider;
import com.linecorp.armeria.server.saml.SamlServiceProviderBuilder;
import com.linecorp.armeria.server.saml.SamlSingleSignOnHandler;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.server.auth.AuthConfig;
import com.linecorp.centraldogma.server.auth.AuthProvider;
import com.linecorp.centraldogma.server.auth.AuthProviderFactory;
import com.linecorp.centraldogma.server.auth.AuthProviderParameters;
import com.linecorp.centraldogma.server.auth.saml.SamlAuthProperties;
import com.linecorp.centraldogma.server.auth.saml.SamlAuthProvider;
import com.linecorp.centraldogma.server.auth.saml.SamlAuthSsoHandler;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import org.opensaml.security.credential.CredentialResolver;

public final class SamlAuthProviderFactory
implements AuthProviderFactory {
    public AuthProvider create(AuthProviderParameters parameters) {
        SamlAuthProperties properties = SamlAuthProviderFactory.getProperties(parameters.authConfig());
        try {
            SamlAuthProperties.KeyStore ks = properties.keyStore();
            SamlAuthProperties.Idp idp = properties.idp();
            SamlServiceProviderBuilder builder = SamlServiceProvider.builder();
            builder.entityId(properties.entityId()).hostname(properties.hostname()).signingKey(properties.signingKey()).encryptionKey(properties.encryptionKey()).authorizer(parameters.authorizer()).ssoHandler((SamlSingleSignOnHandler)new SamlAuthSsoHandler(parameters.sessionIdGenerator(), parameters.loginSessionPropagator(), Duration.ofMillis(parameters.authConfig().sessionTimeoutMillis()), parameters.authConfig().loginNameNormalizer(), properties.idp().subjectLoginNameIdFormat(), properties.idp().attributeLoginName())).credentialResolver(SamlAuthProviderFactory.credentialResolver(ks)).signatureAlgorithm(ks.signatureAlgorithm()).idp().entityId(idp.entityId()).ssoEndpoint(idp.endpoint()).signingKey(idp.signingKey()).encryptionKey(idp.encryptionKey());
            SamlAuthProperties.Acs acs = properties.acs();
            if (acs != null && !acs.endpoints().isEmpty()) {
                acs.endpoints().forEach(arg_0 -> ((SamlServiceProviderBuilder)builder).acs(arg_0));
            }
            return new SamlAuthProvider(builder.build());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create " + SamlAuthProvider.class.getSimpleName(), e);
        }
    }

    private static SamlAuthProperties getProperties(AuthConfig authConfig) {
        try {
            SamlAuthProperties p = (SamlAuthProperties)authConfig.properties(SamlAuthProperties.class);
            Preconditions.checkState((p != null ? 1 : 0) != 0, (Object)"authentication properties are not specified");
            return p;
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to get properties from " + AuthConfig.class.getSimpleName(), e);
        }
    }

    private static CredentialResolver credentialResolver(SamlAuthProperties.KeyStore keyStore) throws IOException, GeneralSecurityException {
        String path = keyStore.path();
        File file = new File(path);
        KeyStoreCredentialResolverBuilder builder = file.isFile() ? new KeyStoreCredentialResolverBuilder(file) : new KeyStoreCredentialResolverBuilder(SamlAuthProviderFactory.class.getClassLoader(), path);
        builder.type(keyStore.type()).password(keyStore.password()).keyPasswords(keyStore.keyPasswords());
        return builder.build();
    }
}

