/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth.saml;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.saml.InvalidSamlRequestException;
import com.linecorp.armeria.server.saml.SamlBindingProtocol;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlSingleSignOnHandler;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import com.linecorp.centraldogma.server.auth.Session;
import com.linecorp.centraldogma.server.auth.saml.HtmlUtil;
import com.linecorp.centraldogma.server.internal.api.HttpApiUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDType;
import org.opensaml.saml.saml2.core.Response;

final class SamlAuthSsoHandler
implements SamlSingleSignOnHandler {
    private final Supplier<String> sessionIdGenerator;
    private final Function<Session, CompletableFuture<Void>> loginSessionPropagator;
    private final Duration sessionValidDuration;
    private final Function<String, String> loginNameNormalizer;
    @Nullable
    private final String subjectLoginNameIdFormat;
    @Nullable
    private final String attributeLoginName;

    SamlAuthSsoHandler(Supplier<String> sessionIdGenerator, Function<Session, CompletableFuture<Void>> loginSessionPropagator, Duration sessionValidDuration, Function<String, String> loginNameNormalizer, @Nullable String subjectLoginNameIdFormat, @Nullable String attributeLoginName) {
        this.sessionIdGenerator = Objects.requireNonNull(sessionIdGenerator, "sessionIdGenerator");
        this.loginSessionPropagator = Objects.requireNonNull(loginSessionPropagator, "loginSessionPropagator");
        this.sessionValidDuration = Objects.requireNonNull(sessionValidDuration, "sessionValidDuration");
        this.loginNameNormalizer = Objects.requireNonNull(loginNameNormalizer, "loginNameNormalizer");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)subjectLoginNameIdFormat) || !Strings.isNullOrEmpty((String)attributeLoginName) ? 1 : 0) != 0, (Object)"a name ID format of a subject or an attribute name should be specified for finding a login name");
        this.subjectLoginNameIdFormat = subjectLoginNameIdFormat;
        this.attributeLoginName = attributeLoginName;
    }

    public CompletionStage<Void> beforeInitiatingSso(ServiceRequestContext ctx, HttpRequest req, MessageContext<AuthnRequest> message, SamlIdentityProviderConfig idpConfig) {
        QueryStringDecoder decoder = new QueryStringDecoder(req.path(), true);
        List ref = (List)decoder.parameters().get("ref");
        if (ref == null || ref.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        String relayState = (String)ref.get(0);
        if (idpConfig.ssoEndpoint().bindingProtocol() == SamlBindingProtocol.HTTP_REDIRECT && relayState.length() > 80) {
            return CompletableFuture.completedFuture(null);
        }
        SAMLBindingContext sub = (SAMLBindingContext)message.getSubcontext(SAMLBindingContext.class, true);
        assert (sub != null) : SAMLBindingContext.class.getName();
        sub.setRelayState(relayState);
        return CompletableFuture.completedFuture(null);
    }

    public HttpResponse loginSucceeded(ServiceRequestContext ctx, AggregatedHttpRequest req, MessageContext<Response> message, @Nullable String sessionIndex, @Nullable String relayState) {
        Response response = (Response)Objects.requireNonNull(message, "message").getMessage();
        String username = Optional.ofNullable(this.findLoginNameFromSubjects(response)).orElseGet(() -> this.findLoginNameFromAttributes(response));
        if (Strings.isNullOrEmpty((String)username)) {
            return this.loginFailed(ctx, req, message, new IllegalStateException("Cannot get a username from the response"));
        }
        String sessionId = this.sessionIdGenerator.get();
        Session session = new Session(sessionId, this.loginNameNormalizer.apply(username), this.sessionValidDuration);
        String redirectionScript = !Strings.isNullOrEmpty((String)relayState) ? "window.location.href='/#" + relayState + '\'' : "window.location.href='/'";
        return HttpResponse.from((CompletionStage)this.loginSessionPropagator.apply(session).thenApply(unused -> HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.HTML_UTF_8, (String)HtmlUtil.getHtmlWithOnload("localStorage.setItem('sessionId','" + sessionId + "')", redirectionScript))));
    }

    @Nullable
    private String findLoginNameFromSubjects(Response response) {
        if (Strings.isNullOrEmpty((String)this.subjectLoginNameIdFormat)) {
            return null;
        }
        return response.getAssertions().stream().map(s -> s.getSubject().getNameID()).filter(nameId -> nameId.getFormat().equals(this.subjectLoginNameIdFormat)).map(NameIDType::getValue).findFirst().orElse(null);
    }

    @Nullable
    private String findLoginNameFromAttributes(Response response) {
        if (Strings.isNullOrEmpty((String)this.attributeLoginName)) {
            return null;
        }
        return response.getAssertions().stream().flatMap(s -> s.getAttributeStatements().stream()).flatMap(s -> s.getAttributes().stream()).filter(attr -> attr.getName().equals(this.attributeLoginName)).findFirst().map(attr -> {
            XMLObject v = (XMLObject)attr.getAttributeValues().get(0);
            if (v instanceof XSString) {
                return ((XSString)v).getValue();
            }
            return null;
        }).orElse(null);
    }

    public HttpResponse loginFailed(ServiceRequestContext ctx, AggregatedHttpRequest req, @Nullable MessageContext<Response> message, Throwable cause) {
        HttpStatus status = cause instanceof InvalidSamlRequestException ? HttpStatus.BAD_REQUEST : HttpStatus.INTERNAL_SERVER_ERROR;
        return HttpApiUtil.newResponse((RequestContext)ctx, (HttpStatus)status, (Throwable)cause);
    }
}

