/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.server.auth.saml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.linecorp.armeria.server.saml.SamlBindingProtocol;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlNameIdFormat;
import com.linecorp.centraldogma.internal.Jackson;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class SamlAuthProperties {
    private static final String DEFAULT_SIGNING_KEY = "signing";
    private static final String DEFAULT_ENCRYPTION_KEY = "encryption";
    private final String entityId;
    private final String hostname;
    private final String signingKey;
    private final String encryptionKey;
    private final KeyStore keyStore;
    private final Idp idp;

    @JsonCreator
    SamlAuthProperties(@JsonProperty(value="entityId") String entityId, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="signingKey") @Nullable String signingKey, @JsonProperty(value="encryptionKey") @Nullable String encryptionKey, @JsonProperty(value="keyStore") KeyStore keyStore, @JsonProperty(value="idp") Idp idp) {
        this.entityId = Objects.requireNonNull(entityId, "entityId");
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        this.signingKey = (String)MoreObjects.firstNonNull((Object)signingKey, (Object)DEFAULT_SIGNING_KEY);
        this.encryptionKey = (String)MoreObjects.firstNonNull((Object)encryptionKey, (Object)DEFAULT_ENCRYPTION_KEY);
        this.keyStore = Objects.requireNonNull(keyStore, "keyStore");
        this.idp = Objects.requireNonNull(idp, "idp");
    }

    @JsonProperty
    public String entityId() {
        return this.entityId;
    }

    @JsonProperty
    public String hostname() {
        return this.hostname;
    }

    @JsonProperty
    public String signingKey() {
        return this.signingKey;
    }

    @JsonProperty
    public String encryptionKey() {
        return this.encryptionKey;
    }

    @JsonProperty
    public KeyStore keyStore() {
        return this.keyStore;
    }

    @JsonProperty
    public Idp idp() {
        return this.idp;
    }

    public String toString() {
        try {
            return Jackson.writeValueAsPrettyString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    static class Idp {
        private final String entityId;
        private final String uri;
        private final SamlBindingProtocol binding;
        private final String signingKey;
        private final String encryptionKey;
        @Nullable
        private final String subjectLoginNameIdFormat;
        @Nullable
        private final String attributeLoginName;

        @JsonCreator
        Idp(@JsonProperty(value="entityId") String entityId, @JsonProperty(value="uri") String uri, @JsonProperty(value="binding") @Nullable String binding, @JsonProperty(value="signingKey") @Nullable String signingKey, @JsonProperty(value="encryptionKey") @Nullable String encryptionKey, @JsonProperty(value="subjectLoginNameIdFormat") @Nullable String subjectLoginNameIdFormat, @JsonProperty(value="attributeLoginName") @Nullable String attributeLoginName) {
            this.entityId = Objects.requireNonNull(entityId, "entityId");
            this.uri = Objects.requireNonNull(uri, "uri");
            this.binding = binding != null ? SamlBindingProtocol.valueOf((String)binding) : SamlBindingProtocol.HTTP_POST;
            this.signingKey = (String)MoreObjects.firstNonNull((Object)signingKey, (Object)entityId);
            this.encryptionKey = (String)MoreObjects.firstNonNull((Object)encryptionKey, (Object)entityId);
            if (subjectLoginNameIdFormat == null && attributeLoginName == null) {
                this.subjectLoginNameIdFormat = SamlNameIdFormat.EMAIL.urn();
                this.attributeLoginName = null;
            } else {
                this.subjectLoginNameIdFormat = subjectLoginNameIdFormat;
                this.attributeLoginName = attributeLoginName;
            }
        }

        @JsonProperty
        public String entityId() {
            return this.entityId;
        }

        @JsonProperty
        public String uri() {
            return this.uri;
        }

        @JsonProperty
        public String binding() {
            return this.binding.name();
        }

        @JsonProperty
        public String signingKey() {
            return this.signingKey;
        }

        @JsonProperty
        public String encryptionKey() {
            return this.encryptionKey;
        }

        @Nullable
        @JsonProperty
        public String subjectLoginNameIdFormat() {
            return this.subjectLoginNameIdFormat;
        }

        @Nullable
        @JsonProperty
        public String attributeLoginName() {
            return this.attributeLoginName;
        }

        public SamlEndpoint endpoint() {
            switch (this.binding) {
                case HTTP_POST: {
                    return SamlEndpoint.ofHttpPost((String)this.uri);
                }
                case HTTP_REDIRECT: {
                    return SamlEndpoint.ofHttpRedirect((String)this.uri);
                }
            }
            throw new IllegalStateException("Failed to get an endpoint of the IdP: " + this.entityId);
        }
    }

    static class KeyStore {
        private static final String DEFAULT_SIGNATURE_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        private final String type;
        private final String path;
        @Nullable
        private final String password;
        private final Map<String, String> keyPasswords;
        private final String signatureAlgorithm;

        @JsonCreator
        KeyStore(@JsonProperty(value="type") @Nullable String type, @JsonProperty(value="path") String path, @JsonProperty(value="password") @Nullable String password, @JsonProperty(value="keyPasswords") @Nullable Map<String, String> keyPasswords, @JsonProperty(value="signatureAlgorithm") @Nullable String signatureAlgorithm) {
            this.type = (String)MoreObjects.firstNonNull((Object)type, (Object)java.security.KeyStore.getDefaultType());
            this.path = Objects.requireNonNull(path, "path");
            this.password = password;
            this.keyPasswords = KeyStore.sanitizePasswords(keyPasswords);
            this.signatureAlgorithm = (String)MoreObjects.firstNonNull((Object)signatureAlgorithm, (Object)DEFAULT_SIGNATURE_ALGORITHM);
        }

        private static Map<String, String> sanitizePasswords(@Nullable Map<String, String> keyPasswords) {
            if (keyPasswords == null) {
                return ImmutableMap.of();
            }
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            keyPasswords.forEach((key, password) -> builder.put(key, (Object)((String)MoreObjects.firstNonNull((Object)password, (Object)""))));
            return builder.build();
        }

        @JsonProperty
        public String type() {
            return this.type;
        }

        @JsonProperty
        public String path() {
            return this.path;
        }

        @Nullable
        @JsonProperty
        public String password() {
            return this.password;
        }

        @JsonProperty
        public Map<String, String> keyPasswords() {
            return this.keyPasswords;
        }

        @JsonProperty
        public String signatureAlgorithm() {
            return this.signatureAlgorithm;
        }
    }
}

