/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.PathPattern;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class HistoryRequest {
    private final CentralDogmaRepository centralDogmaRepo;
    private final PathPattern pathPattern;
    private int maxCommits;

    HistoryRequest(CentralDogmaRepository centralDogmaRepo, PathPattern pathPattern) {
        this.centralDogmaRepo = centralDogmaRepo;
        this.pathPattern = pathPattern;
    }

    public HistoryRequest maxCommits(int maxCommits) {
        Preconditions.checkArgument((maxCommits >= 0 && maxCommits <= 1000 ? 1 : 0) != 0, (String)"maxCommits: %s (expected: 0 <= maxCommits <= %s)", (int)maxCommits, (int)1000);
        this.maxCommits = maxCommits;
        return this;
    }

    public CompletableFuture<List<Commit>> get(Revision from, Revision to) {
        Objects.requireNonNull(from, "from");
        Objects.requireNonNull(to, "to");
        return this.centralDogmaRepo.centralDogma().getHistory(this.centralDogmaRepo.projectName(), this.centralDogmaRepo.repositoryName(), from, to, this.pathPattern, this.maxCommits);
    }
}

