/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.PathPattern;
import com.linecorp.centraldogma.common.Revision;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class FilesRequest {
    private final CentralDogmaRepository centralDogmaRepo;
    private final PathPattern pathPattern;

    FilesRequest(CentralDogmaRepository centralDogmaRepo, PathPattern pathPattern) {
        this.centralDogmaRepo = centralDogmaRepo;
        this.pathPattern = pathPattern;
    }

    public CompletableFuture<Map<String, EntryType>> list() {
        return this.list(Revision.HEAD);
    }

    public CompletableFuture<Map<String, EntryType>> list(Revision revision) {
        Objects.requireNonNull(revision, "revision");
        return this.centralDogmaRepo.centralDogma().listFiles(this.centralDogmaRepo.projectName(), this.centralDogmaRepo.repositoryName(), revision, this.pathPattern);
    }

    public CompletableFuture<Map<String, Entry<?>>> get() {
        return this.get(Revision.HEAD);
    }

    public CompletableFuture<Map<String, Entry<?>>> get(Revision revision) {
        Objects.requireNonNull(revision, "revision");
        return this.centralDogmaRepo.centralDogma().getFiles(this.centralDogmaRepo.projectName(), this.centralDogmaRepo.repositoryName(), revision, this.pathPattern);
    }
}

