/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.CentralDogmaRepository;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.PushResult;
import com.linecorp.centraldogma.common.Revision;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class CommitRequest {
    private final CentralDogmaRepository centralDogmaRepo;
    private final String summary;
    private final Iterable<? extends Change<?>> changes;
    private String detail = "";
    private Markup markup = Markup.PLAINTEXT;

    CommitRequest(CentralDogmaRepository centralDogmaRepo, String summary, Iterable<? extends Change<?>> changes) {
        this.centralDogmaRepo = centralDogmaRepo;
        this.summary = summary;
        this.changes = changes;
    }

    public CommitRequest detail(String detail, Markup markup) {
        this.detail = Objects.requireNonNull(detail, "detail");
        this.markup = Objects.requireNonNull(markup, "markup");
        return this;
    }

    public CompletableFuture<PushResult> push() {
        return this.push(Revision.HEAD);
    }

    public CompletableFuture<PushResult> push(Revision baseRevision) {
        Objects.requireNonNull(baseRevision, "baseRevision");
        return this.centralDogmaRepo.centralDogma().push(this.centralDogmaRepo.projectName(), this.centralDogmaRepo.repositoryName(), baseRevision, this.summary, this.detail, this.markup, this.changes);
    }
}

