/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.CommitRequest;
import com.linecorp.centraldogma.client.DiffFilesRequest;
import com.linecorp.centraldogma.client.DiffRequest;
import com.linecorp.centraldogma.client.FileRequest;
import com.linecorp.centraldogma.client.FilesRequest;
import com.linecorp.centraldogma.client.HistoryRequest;
import com.linecorp.centraldogma.client.MergeRequest;
import com.linecorp.centraldogma.client.PreviewDiffRequest;
import com.linecorp.centraldogma.client.WatchFilesRequest;
import com.linecorp.centraldogma.client.WatchRequest;
import com.linecorp.centraldogma.client.WatcherRequest;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergeSource;
import com.linecorp.centraldogma.common.PathPattern;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public final class CentralDogmaRepository {
    private final CentralDogma centralDogma;
    private final String projectName;
    private final String repositoryName;
    private final ScheduledExecutorService blockingTaskExecutor;
    @Nullable
    private final MeterRegistry meterRegistry;

    CentralDogmaRepository(CentralDogma centralDogma, String projectName, String repositoryName, ScheduledExecutorService blockingTaskExecutor, @Nullable MeterRegistry meterRegistry) {
        this.centralDogma = centralDogma;
        this.projectName = projectName;
        this.repositoryName = repositoryName;
        this.blockingTaskExecutor = blockingTaskExecutor;
        this.meterRegistry = meterRegistry;
    }

    CentralDogma centralDogma() {
        return this.centralDogma;
    }

    public String projectName() {
        return this.projectName;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public CompletableFuture<Revision> normalize(Revision revision) {
        Objects.requireNonNull(revision, "revision");
        return this.centralDogma.normalizeRevision(this.projectName, this.repositoryName, revision);
    }

    public FileRequest<?> file(String path) {
        Objects.requireNonNull(path, "path");
        return this.file(Query.of((QueryType)QueryType.IDENTITY, (String)path, (String[])new String[0]));
    }

    public <T> FileRequest<T> file(Query<T> query) {
        Objects.requireNonNull(query, "query");
        return new FileRequest<T>(this, query);
    }

    public FilesRequest file(PathPattern pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        return new FilesRequest(this, pathPattern);
    }

    public MergeRequest<?> merge(MergeSource ... mergeSources) {
        Objects.requireNonNull(mergeSources, "mergeSources");
        return this.merge((Iterable<MergeSource>)ImmutableList.copyOf((Object[])mergeSources));
    }

    public MergeRequest<?> merge(Iterable<MergeSource> mergeSources) {
        Objects.requireNonNull(mergeSources, "mergeSources");
        return this.merge(MergeQuery.ofJson(mergeSources));
    }

    public <T> MergeRequest<T> merge(MergeQuery<T> mergeQuery) {
        Objects.requireNonNull(mergeQuery, "mergeQuery");
        return new MergeRequest<T>(this, mergeQuery);
    }

    public HistoryRequest history() {
        return this.history(PathPattern.all());
    }

    public HistoryRequest history(PathPattern pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        return new HistoryRequest(this, pathPattern);
    }

    public DiffRequest<?> diff(String path) {
        Objects.requireNonNull(path, "path");
        return this.diff(Query.of((QueryType)QueryType.IDENTITY, (String)path, (String[])new String[0]));
    }

    public <T> DiffRequest<T> diff(Query<T> query) {
        Objects.requireNonNull(query, "query");
        return new DiffRequest<T>(this, query);
    }

    public DiffFilesRequest diff(PathPattern pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        return new DiffFilesRequest(this, pathPattern);
    }

    public PreviewDiffRequest diff(Change<?> ... changes) {
        Objects.requireNonNull(changes, "changes");
        return new PreviewDiffRequest(this, (Iterable<? extends Change<?>>)ImmutableList.copyOf((Object[])changes));
    }

    public PreviewDiffRequest diff(Iterable<? extends Change<?>> changes) {
        Objects.requireNonNull(changes, "changes");
        return new PreviewDiffRequest(this, changes);
    }

    public CommitRequest commit(String summary, Change<?> ... changes) {
        Objects.requireNonNull(changes, "changes");
        return this.commit(summary, (Iterable<? extends Change<?>>)ImmutableList.copyOf((Object[])changes));
    }

    public CommitRequest commit(String summary, Iterable<? extends Change<?>> changes) {
        Objects.requireNonNull(summary, "summary");
        Objects.requireNonNull(changes, "changes");
        return new CommitRequest(this, summary, changes);
    }

    public WatchRequest<?> watch(String path) {
        Objects.requireNonNull(path, "path");
        return this.watch(Query.of((QueryType)QueryType.IDENTITY, (String)path, (String[])new String[0]));
    }

    public <T> WatchRequest<T> watch(Query<T> query) {
        Objects.requireNonNull(query, "query");
        return new WatchRequest<T>(this, query);
    }

    public WatchFilesRequest watch(PathPattern pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        return new WatchFilesRequest(this, pathPattern);
    }

    public <T> WatcherRequest<T> watcher(Query<T> query) {
        Objects.requireNonNull(query, "query");
        return new WatcherRequest<T>(this, query, this.blockingTaskExecutor, this.meterRegistry);
    }

    public WatcherRequest<Revision> watcher(PathPattern pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        return new WatcherRequest<Revision>(this, pathPattern, this.blockingTaskExecutor, this.meterRegistry);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CentralDogmaRepository)) {
            return false;
        }
        CentralDogmaRepository that = (CentralDogmaRepository)o;
        return this.centralDogma == that.centralDogma && this.projectName.equals(that.projectName) && this.repositoryName.equals(that.repositoryName) && this.blockingTaskExecutor == that.blockingTaskExecutor;
    }

    public int hashCode() {
        return Objects.hash(this.centralDogma, this.projectName, this.repositoryName, this.blockingTaskExecutor);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("centralDogma", (Object)this.centralDogma).add("projectName", (Object)this.projectName).add("repositoryName", (Object)this.repositoryName).add("blockingTaskExecutor", (Object)this.blockingTaskExecutor).toString();
    }
}

