/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.updater;

import com.linecorp.centraldogma.client.updater.CentralDogmaBeanConfigBuilder;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class CentralDogmaBeanConfig {
    static final CentralDogmaBeanConfig EMPTY = new CentralDogmaBeanConfigBuilder().build();
    private final String project;
    private final String repository;
    private final String path;
    private final String jsonPath;

    public CentralDogmaBeanConfig(@Nullable String project, @Nullable String repository, @Nullable String path, @Nullable String jsonPath) {
        this.project = Strings.emptyToNull((String)project);
        this.repository = Strings.emptyToNull((String)repository);
        this.path = Strings.emptyToNull((String)path);
        this.jsonPath = Strings.emptyToNull((String)jsonPath);
        if (this.path != null) {
            Util.validateFilePath((String)this.path, (String)"path");
        }
    }

    public Optional<String> project() {
        return Optional.ofNullable(this.project);
    }

    public Optional<String> repository() {
        return Optional.ofNullable(this.repository);
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public Optional<String> jsonPath() {
        return Optional.ofNullable(this.jsonPath);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CentralDogmaBeanConfig)) {
            return false;
        }
        CentralDogmaBeanConfig other = (CentralDogmaBeanConfig)o;
        return Objects.equals(this.project, other.project) && Objects.equals(this.repository, other.repository) && Objects.equals(this.path, other.path) && Objects.equals(this.jsonPath, other.jsonPath);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.repository, this.path, this.jsonPath);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("project", (Object)this.project).add("repository", (Object)this.repository).add("path", (Object)this.path).add("jsonPath", (Object)this.jsonPath).toString();
    }
}

