/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.WatchConstants;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import java.time.Duration;
import java.util.Objects;

abstract class WatchOptions {
    private long timeoutMillis = WatchConstants.DEFAULT_WATCH_TIMEOUT_MILLIS;
    private boolean errorOnEntryNotFound = false;

    WatchOptions() {
    }

    WatchOptions timeout(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        Preconditions.checkArgument((!timeout.isZero() && !timeout.isNegative() ? 1 : 0) != 0, (String)"timeout: %s (expected: > 0)", (Object)timeout);
        return this.timeoutMillis(timeout.toMillis());
    }

    WatchOptions timeoutMillis(long timeoutMillis) {
        Preconditions.checkArgument((timeoutMillis > 0L ? 1 : 0) != 0, (String)"timeoutMillis: %s (expected: > 0)", (long)timeoutMillis);
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    long timeoutMillis() {
        return this.timeoutMillis;
    }

    public WatchOptions errorOnEntryNotFound(boolean errorOnEntryNotFound) {
        this.errorOnEntryNotFound = errorOnEntryNotFound;
        return this;
    }

    boolean errorOnEntryNotFound() {
        return this.errorOnEntryNotFound;
    }
}

