/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.client;

import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.client.AbstractWatcher;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public final class RepositoryWatcher<T>
extends AbstractWatcher<T> {
    private final String pathPattern;
    private final Function<Revision, ? extends T> function;

    public RepositoryWatcher(CentralDogma client, ScheduledExecutorService executor, String projectName, String repositoryName, String pathPattern, Function<Revision, ? extends T> function) {
        super(client, executor, projectName, repositoryName, pathPattern);
        this.pathPattern = Objects.requireNonNull(pathPattern, "pathPattern");
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    protected CompletableFuture<Latest<T>> doWatch(CentralDogma client, String projectName, String repositoryName, Revision lastKnownRevision) {
        return client.watchRepository(projectName, repositoryName, lastKnownRevision, this.pathPattern).thenApply(revision -> {
            if (revision == null) {
                return null;
            }
            return new Latest<T>((Revision)revision, this.function.apply((Revision)revision));
        });
    }
}

