/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.client;

import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.client.AbstractWatcher;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public final class FileWatcher<T>
extends AbstractWatcher<T> {
    private final Query<Object> query;
    private final Function<Object, ? extends T> function;

    public <U> FileWatcher(CentralDogma client, ScheduledExecutorService executor, String projectName, String repositoryName, Query<U> query, Function<? super U, ? extends T> function) {
        super(client, executor, projectName, repositoryName, Objects.requireNonNull(query, "query").path());
        this.query = (Query)Util.unsafeCast(query);
        this.function = (Function)Util.unsafeCast(Objects.requireNonNull(function, "function"));
    }

    @Override
    protected CompletableFuture<Latest<T>> doWatch(CentralDogma client, String projectName, String repositoryName, Revision lastKnownRevision) {
        return client.watchFile(projectName, repositoryName, lastKnownRevision, this.query).thenApply(result -> {
            if (result == null) {
                return null;
            }
            return new Latest<T>(result.revision(), this.function.apply(result.content()));
        });
    }
}

