/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.internal.client;

import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.client.Watcher;
import com.linecorp.centraldogma.common.CentralDogmaException;
import com.linecorp.centraldogma.common.EntryNotFoundException;
import com.linecorp.centraldogma.common.RepositoryNotFoundException;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.common.ShuttingDownException;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.math.LongMath;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractWatcher<T>
implements Watcher<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWatcher.class);
    private static final long DELAY_ON_SUCCESS_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final long MIN_INTERVAL_MILLIS = DELAY_ON_SUCCESS_MILLIS * 2L;
    private static final long MAX_INTERVAL_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final double JITTER_RATE = 0.2;
    private final CentralDogma client;
    private final ScheduledExecutorService executor;
    private final String projectName;
    private final String repositoryName;
    private final String pathPattern;
    private final List<BiConsumer<? super Revision, ? super T>> updateListeners;
    private final AtomicReference<State> state;
    private final CompletableFuture<Latest<T>> initialValueFuture;
    private volatile Latest<T> latest;
    private volatile ScheduledFuture<?> currentScheduleFuture;
    private volatile CompletableFuture<?> currentWatchFuture;

    private static long nextDelayMillis(int numAttemptsSoFar) {
        long nextDelayMillis = numAttemptsSoFar == 1 ? MIN_INTERVAL_MILLIS : Math.min(AbstractWatcher.saturatedMultiply(MIN_INTERVAL_MILLIS, Math.pow(2.0, numAttemptsSoFar - 1)), MAX_INTERVAL_MILLIS);
        long minJitter = (long)((double)nextDelayMillis * 0.8);
        long maxJitter = (long)((double)nextDelayMillis * 1.2);
        long bound = maxJitter - minJitter + 1L;
        long millis = AbstractWatcher.random(bound);
        return Math.max(0L, LongMath.saturatedAdd((long)minJitter, (long)millis));
    }

    private static long saturatedMultiply(long left, double right) {
        double result = (double)left * right;
        return result >= 9.223372036854776E18 ? Long.MAX_VALUE : (long)result;
    }

    private static long random(long bound) {
        assert (bound > 0L);
        long mask = bound - 1L;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long result = ((Random)random).nextLong();
        if ((bound & mask) == 0L) {
            result &= mask;
        } else {
            long u = result >>> 1;
            while (u + mask - (result = u % bound) < 0L) {
                u = ((Random)random).nextLong() >>> 1;
            }
        }
        return result;
    }

    protected AbstractWatcher(CentralDogma client, ScheduledExecutorService executor, String projectName, String repositoryName, String pathPattern) {
        this.client = Objects.requireNonNull(client, "client");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.projectName = Objects.requireNonNull(projectName, "projectName");
        this.repositoryName = Objects.requireNonNull(repositoryName, "repositoryName");
        this.pathPattern = Objects.requireNonNull(pathPattern, "pathPattern");
        this.updateListeners = new CopyOnWriteArrayList<BiConsumer<? super Revision, ? super T>>();
        this.state = new AtomicReference<State>(State.INIT);
        this.initialValueFuture = new CompletableFuture();
    }

    @Override
    public CompletableFuture<Latest<T>> initialValueFuture() {
        return this.initialValueFuture;
    }

    @Override
    public Latest<T> latest() {
        Latest<T> latest = this.latest;
        if (latest == null) {
            throw new IllegalStateException("value not available yet");
        }
        return latest;
    }

    public void start() {
        if (this.state.compareAndSet(State.INIT, State.STARTED)) {
            this.scheduleWatch(0);
        }
    }

    @Override
    public void close() {
        CompletableFuture<?> currentWatchFuture;
        ScheduledFuture<?> currentScheduleFuture;
        this.state.set(State.STOPPED);
        if (!this.initialValueFuture.isDone()) {
            this.initialValueFuture.cancel(false);
        }
        if ((currentScheduleFuture = this.currentScheduleFuture) != null && !currentScheduleFuture.isDone()) {
            currentScheduleFuture.cancel(false);
        }
        if ((currentWatchFuture = this.currentWatchFuture) != null && !currentWatchFuture.isDone()) {
            currentWatchFuture.cancel(false);
        }
    }

    private boolean isStopped() {
        return this.state.get() == State.STOPPED;
    }

    @Override
    public void watch(BiConsumer<? super Revision, ? super T> listener) {
        Objects.requireNonNull(listener, "listener");
        Preconditions.checkState((!this.isStopped() ? 1 : 0) != 0, (Object)"watcher closed");
        this.updateListeners.add(listener);
        if (this.latest != null) {
            try {
                this.executor.execute(() -> {
                    Latest<T> latest = this.latest;
                    listener.accept((Revision)latest.revision(), (T)latest.value());
                });
            }
            catch (RejectedExecutionException e) {
                this.handleEventLoopShutdown(e);
            }
        }
    }

    private void scheduleWatch(int numAttemptsSoFar) {
        if (this.isStopped()) {
            return;
        }
        long delay = numAttemptsSoFar == 0 ? (this.latest != null ? DELAY_ON_SUCCESS_MILLIS : 0L) : AbstractWatcher.nextDelayMillis(numAttemptsSoFar);
        try {
            this.currentScheduleFuture = this.executor.schedule(() -> {
                this.currentScheduleFuture = null;
                this.doWatch(numAttemptsSoFar);
            }, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            this.handleEventLoopShutdown(e);
        }
    }

    private void doWatch(int numAttemptsSoFar) {
        if (this.isStopped()) {
            return;
        }
        Revision lastKnownRevision = this.latest != null ? this.latest.revision() : Revision.INIT;
        CompletableFuture<Latest<T>> f = this.doWatch(this.client, this.projectName, this.repositoryName, lastKnownRevision);
        this.currentWatchFuture = f;
        ((CompletableFuture)((CompletableFuture)f.whenComplete((result, cause) -> {
            this.currentWatchFuture = null;
        })).thenAccept(newLatest -> {
            if (newLatest != null) {
                Latest<T> oldLatest = this.latest;
                this.latest = newLatest;
                logger.debug("watcher noticed updated file {}/{}{}: rev={}", new Object[]{this.projectName, this.repositoryName, this.pathPattern, newLatest.revision()});
                this.notifyListeners();
                if (oldLatest == null) {
                    this.initialValueFuture.complete((Latest<Latest>)newLatest);
                }
            }
            this.scheduleWatch(0);
        })).exceptionally(thrown -> {
            try {
                Throwable cause = thrown instanceof CompletionException ? thrown.getCause() : thrown;
                boolean logged = false;
                if (cause instanceof CentralDogmaException) {
                    if (cause instanceof EntryNotFoundException) {
                        logger.info("{}/{}{} does not exist yet; trying again", new Object[]{this.projectName, this.repositoryName, this.pathPattern});
                        logged = true;
                    } else if (cause instanceof RepositoryNotFoundException) {
                        logger.info("{}/{} does not exist yet; trying again", (Object)this.projectName, (Object)this.repositoryName);
                        logged = true;
                    } else if (cause instanceof ShuttingDownException) {
                        logger.info("Central Dogma is shutting down; trying again");
                        logged = true;
                    }
                }
                if (cause instanceof CancellationException) {
                    return null;
                }
                if (!logged) {
                    logger.warn("Failed to watch a file ({}/{}{}); trying again", new Object[]{this.projectName, this.repositoryName, this.pathPattern, cause});
                }
                this.scheduleWatch(numAttemptsSoFar + 1);
            }
            catch (Throwable t) {
                logger.error("Unexpected exception while watching a file:", t);
            }
            return null;
        });
    }

    protected abstract CompletableFuture<Latest<T>> doWatch(CentralDogma var1, String var2, String var3, Revision var4);

    private void notifyListeners() {
        if (this.isStopped()) {
            return;
        }
        Latest<T> latest = this.latest;
        for (BiConsumer<Revision, ? super Revision> biConsumer : this.updateListeners) {
            biConsumer.accept((Revision)((Revision)latest.revision()), (Revision)latest.value());
        }
    }

    private void handleEventLoopShutdown(RejectedExecutionException e) {
        if (logger.isTraceEnabled()) {
            logger.trace("Stopping to watch since the event loop is shut down:", (Throwable)e);
        } else {
            logger.debug("Stopping to watch since the event loop is shut down.");
        }
        this.close();
    }

    private static enum State {
        INIT,
        STARTED,
        STOPPED;

    }
}

