/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.updater;

import com.linecorp.centraldogma.client.updater.CentralDogmaBean;
import com.linecorp.centraldogma.client.updater.CentralDogmaBeanConfig;
import com.linecorp.centraldogma.internal.Util;
import com.linecorp.centraldogma.internal.shaded.guava.base.Strings;
import java.util.Objects;
import javax.annotation.Nullable;

public final class CentralDogmaBeanConfigBuilder {
    @Nullable
    private String project;
    @Nullable
    private String repository;
    @Nullable
    private String path;
    @Nullable
    private String jsonPath;

    public CentralDogmaBeanConfigBuilder() {
    }

    public CentralDogmaBeanConfigBuilder(CentralDogmaBeanConfig config) {
        this.merge(config);
    }

    public CentralDogmaBeanConfigBuilder(CentralDogmaBean config) {
        this.project = Strings.emptyToNull((String)config.project());
        this.repository = Strings.emptyToNull((String)config.repository());
        this.path = Strings.emptyToNull((String)config.path());
        this.jsonPath = Strings.emptyToNull((String)config.jsonPath());
    }

    public CentralDogmaBeanConfigBuilder merge(CentralDogmaBeanConfig config) {
        config.project().ifPresent(this::project);
        config.repository().ifPresent(this::repository);
        config.path().ifPresent(this::path);
        config.jsonPath().ifPresent(this::jsonPath);
        return this;
    }

    public CentralDogmaBeanConfigBuilder project(String project) {
        this.project = Objects.requireNonNull(project, "project");
        return this;
    }

    public CentralDogmaBeanConfigBuilder repository(String repository) {
        this.repository = Objects.requireNonNull(repository, "repository");
        return this;
    }

    public CentralDogmaBeanConfigBuilder path(String path) {
        this.path = Util.validateFilePath((String)path, (String)"path");
        return this;
    }

    public CentralDogmaBeanConfigBuilder jsonPath(String jsonPath) {
        this.jsonPath = Objects.requireNonNull(jsonPath, "jsonPath");
        return this;
    }

    public CentralDogmaBeanConfig build() {
        return new CentralDogmaBeanConfig(this.project, this.repository, this.path, this.jsonPath);
    }
}

