/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.Latest;
import com.linecorp.centraldogma.common.Revision;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public interface Watcher<T>
extends AutoCloseable {
    public CompletableFuture<Latest<T>> initialValueFuture();

    default public Latest<T> awaitInitialValue() throws InterruptedException {
        try {
            return this.initialValueFuture().get();
        }
        catch (ExecutionException e) {
            throw new Error(e);
        }
    }

    default public Latest<T> awaitInitialValue(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Objects.requireNonNull(unit, "unit");
        try {
            return this.initialValueFuture().get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw new Error(e);
        }
    }

    @Nullable
    default public T awaitInitialValue(long timeout, TimeUnit unit, @Nullable T defaultValue) throws InterruptedException {
        try {
            return this.awaitInitialValue(timeout, unit).value();
        }
        catch (TimeoutException e) {
            return defaultValue;
        }
    }

    public Latest<T> latest();

    @Nullable
    default public T latestValue() {
        return this.latest().value();
    }

    @Nullable
    default public T latestValue(@Nullable T defaultValue) {
        CompletableFuture<Latest<T>> initialValueFuture = this.initialValueFuture();
        if (initialValueFuture.isDone() && !initialValueFuture.isCompletedExceptionally()) {
            return this.latest().value();
        }
        return defaultValue;
    }

    @Override
    public void close();

    public void watch(BiConsumer<? super Revision, ? super T> var1);

    default public void watch(Consumer<? super T> listener) {
        Objects.requireNonNull(listener, "listener");
        this.watch((? super Revision revision, ? super T value) -> listener.accept(value));
    }
}

