/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.linecorp.centraldogma.client.RepositoryInfo;
import com.linecorp.centraldogma.client.WatchConstants;
import com.linecorp.centraldogma.client.Watcher;
import com.linecorp.centraldogma.common.Author;
import com.linecorp.centraldogma.common.Change;
import com.linecorp.centraldogma.common.Commit;
import com.linecorp.centraldogma.common.Entry;
import com.linecorp.centraldogma.common.EntryType;
import com.linecorp.centraldogma.common.Markup;
import com.linecorp.centraldogma.common.MergeQuery;
import com.linecorp.centraldogma.common.MergeSource;
import com.linecorp.centraldogma.common.MergedEntry;
import com.linecorp.centraldogma.common.PushResult;
import com.linecorp.centraldogma.common.Query;
import com.linecorp.centraldogma.common.QueryType;
import com.linecorp.centraldogma.common.Revision;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface CentralDogma {
    public CompletableFuture<Void> createProject(String var1);

    public CompletableFuture<Void> removeProject(String var1);

    public CompletableFuture<Void> purgeProject(String var1);

    public CompletableFuture<Void> unremoveProject(String var1);

    public CompletableFuture<Set<String>> listProjects();

    public CompletableFuture<Set<String>> listRemovedProjects();

    public CompletableFuture<Void> createRepository(String var1, String var2);

    public CompletableFuture<Void> removeRepository(String var1, String var2);

    public CompletableFuture<Void> purgeRepository(String var1, String var2);

    public CompletableFuture<Void> unremoveRepository(String var1, String var2);

    public CompletableFuture<Map<String, RepositoryInfo>> listRepositories(String var1);

    public CompletableFuture<Set<String>> listRemovedRepositories(String var1);

    public CompletableFuture<Revision> normalizeRevision(String var1, String var2, Revision var3);

    public CompletableFuture<Map<String, EntryType>> listFiles(String var1, String var2, Revision var3, String var4);

    default public CompletableFuture<Entry<?>> getFile(String projectName, String repositoryName, Revision revision, String path) {
        CompletableFuture<Entry<?>> f = this.getFile(projectName, repositoryName, revision, Query.of((QueryType)QueryType.IDENTITY, (String)path, (String[])new String[0]));
        return f;
    }

    public <T> CompletableFuture<Entry<T>> getFile(String var1, String var2, Revision var3, Query<T> var4);

    public CompletableFuture<Map<String, Entry<?>>> getFiles(String var1, String var2, Revision var3, String var4);

    default public CompletableFuture<MergedEntry<?>> mergeFiles(String projectName, String repositoryName, Revision revision, MergeSource ... mergeSources) {
        return this.mergeFiles(projectName, repositoryName, revision, (Iterable<MergeSource>)ImmutableList.copyOf((Object[])Objects.requireNonNull(mergeSources, "mergeSources")));
    }

    default public CompletableFuture<MergedEntry<?>> mergeFiles(String projectName, String repositoryName, Revision revision, Iterable<MergeSource> mergeSources) {
        CompletableFuture<MergedEntry<?>> future = this.mergeFiles(projectName, repositoryName, revision, MergeQuery.ofJson(mergeSources));
        return future;
    }

    public <T> CompletableFuture<MergedEntry<T>> mergeFiles(String var1, String var2, Revision var3, MergeQuery<T> var4);

    default public CompletableFuture<List<Commit>> getHistory(String projectName, String repositoryName, Revision from, Revision to) {
        return this.getHistory(projectName, repositoryName, from, to, "/**");
    }

    public CompletableFuture<List<Commit>> getHistory(String var1, String var2, Revision var3, Revision var4, String var5);

    default public CompletableFuture<Change<?>> getDiff(String projectName, String repositoryName, Revision from, Revision to, String path) {
        CompletableFuture<Change<?>> diff = this.getDiff(projectName, repositoryName, from, to, Query.of((QueryType)QueryType.IDENTITY, (String)path, (String[])new String[0]));
        return diff;
    }

    public <T> CompletableFuture<Change<T>> getDiff(String var1, String var2, Revision var3, Revision var4, Query<T> var5);

    public CompletableFuture<List<Change<?>>> getDiffs(String var1, String var2, Revision var3, Revision var4, String var5);

    default public CompletableFuture<List<Change<?>>> getPreviewDiffs(String projectName, String repositoryName, Revision baseRevision, Change<?> ... changes) {
        return this.getPreviewDiffs(projectName, repositoryName, baseRevision, (Iterable<? extends Change<?>>)ImmutableList.copyOf((Object[])changes));
    }

    public CompletableFuture<List<Change<?>>> getPreviewDiffs(String var1, String var2, Revision var3, Iterable<? extends Change<?>> var4);

    default public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, String summary, Change<?> ... changes) {
        return this.push(projectName, repositoryName, baseRevision, summary, (Iterable<? extends Change<?>>)ImmutableList.copyOf((Object[])Objects.requireNonNull(changes, "changes")));
    }

    default public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, String summary, Iterable<? extends Change<?>> changes) {
        return this.push(projectName, repositoryName, baseRevision, summary, "", Markup.PLAINTEXT, changes);
    }

    default public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, String summary, String detail, Markup markup, Change<?> ... changes) {
        return this.push(projectName, repositoryName, baseRevision, summary, detail, markup, (Iterable<? extends Change<?>>)ImmutableList.copyOf((Object[])Objects.requireNonNull(changes, "changes")));
    }

    public CompletableFuture<PushResult> push(String var1, String var2, Revision var3, String var4, String var5, Markup var6, Iterable<? extends Change<?>> var7);

    @Deprecated
    default public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, Author author, String summary, Change<?> ... changes) {
        return this.push(projectName, repositoryName, baseRevision, author, summary, (Iterable<? extends Change<?>>)ImmutableList.copyOf((Object[])changes));
    }

    @Deprecated
    default public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, Author author, String summary, Iterable<? extends Change<?>> changes) {
        return this.push(projectName, repositoryName, baseRevision, author, summary, "", Markup.PLAINTEXT, changes);
    }

    @Deprecated
    default public CompletableFuture<PushResult> push(String projectName, String repositoryName, Revision baseRevision, Author author, String summary, String detail, Markup markup, Change<?> ... changes) {
        return this.push(projectName, repositoryName, baseRevision, author, summary, detail, markup, (Iterable<? extends Change<?>>)ImmutableList.copyOf((Object[])changes));
    }

    @Deprecated
    public CompletableFuture<PushResult> push(String var1, String var2, Revision var3, Author var4, String var5, String var6, Markup var7, Iterable<? extends Change<?>> var8);

    default public CompletableFuture<Revision> watchRepository(String projectName, String repositoryName, Revision lastKnownRevision, String pathPattern) {
        return this.watchRepository(projectName, repositoryName, lastKnownRevision, pathPattern, WatchConstants.DEFAULT_WATCH_TIMEOUT_MILLIS);
    }

    public CompletableFuture<Revision> watchRepository(String var1, String var2, Revision var3, String var4, long var5);

    default public <T> CompletableFuture<Entry<T>> watchFile(String projectName, String repositoryName, Revision lastKnownRevision, Query<T> query) {
        return this.watchFile(projectName, repositoryName, lastKnownRevision, query, WatchConstants.DEFAULT_WATCH_TIMEOUT_MILLIS);
    }

    public <T> CompletableFuture<Entry<T>> watchFile(String var1, String var2, Revision var3, Query<T> var4, long var5);

    default public <T> Watcher<T> fileWatcher(String projectName, String repositoryName, Query<T> query) {
        return this.fileWatcher(projectName, repositoryName, query, Function.identity());
    }

    public <T, U> Watcher<U> fileWatcher(String var1, String var2, Query<T> var3, Function<? super T, ? extends U> var4);

    default public Watcher<Revision> repositoryWatcher(String projectName, String repositoryName, String pathPattern) {
        return this.repositoryWatcher(projectName, repositoryName, pathPattern, Function.identity());
    }

    public <T> Watcher<T> repositoryWatcher(String var1, String var2, String var3, Function<Revision, ? extends T> var4);
}

