/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.centraldogma.client.ClientProfile;
import com.linecorp.centraldogma.internal.shaded.guava.base.Preconditions;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.centraldogma.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.centraldogma.internal.shaded.guava.collect.Iterables;
import com.linecorp.centraldogma.internal.shaded.guava.net.InetAddresses;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractCentralDogmaBuilder<B extends AbstractCentralDogmaBuilder<B>> {
    private static final String TEST_PROFILE_RESOURCE_PATH = "centraldogma-profiles-test.json";
    private static final String PROFILE_RESOURCE_PATH = "centraldogma-profiles.json";
    private static final List<String> DEFAULT_PROFILE_RESOURCE_PATHS = ImmutableList.of((Object)"centraldogma-profiles-test.json", (Object)"centraldogma-profiles.json");
    static final int DEFAULT_PORT = 36462;
    private ImmutableSet<InetSocketAddress> hosts = ImmutableSet.of();
    private boolean useTls;
    private List<String> profileResourcePaths = DEFAULT_PROFILE_RESOURCE_PATHS;
    @Nullable
    private String selectedProfile;
    private String accessToken = "anonymous";

    protected final B self() {
        return (B)this;
    }

    @Deprecated
    public final B uri(String uri) {
        URI parsed = URI.create(Objects.requireNonNull(uri, "uri"));
        String host = parsed.getHost();
        int port = parsed.getPort();
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (String)"uri: %s (must contain a host part)", (Object)uri);
        if (port < 0) {
            this.host(host);
        } else {
            this.host(host, port);
        }
        return this.self();
    }

    public final B host(String host) {
        return this.host(host, 36462);
    }

    public final B host(String host, int port) {
        Objects.requireNonNull(host, "host");
        Preconditions.checkArgument((!host.startsWith("group:") ? 1 : 0) != 0, (String)"host: %s (must not start with 'group:')", (Object)host);
        Preconditions.checkArgument((port >= 1 && port < 65536 ? 1 : 0) != 0, (String)"port: %s (expected: 1 .. 65535)", (int)port);
        InetSocketAddress addr = AbstractCentralDogmaBuilder.newEndpoint(host, port);
        Preconditions.checkState((this.selectedProfile == null ? 1 : 0) != 0, (Object)"profile() and host() cannot be used together.");
        this.hosts = ImmutableSet.builder().addAll(this.hosts).add((Object)addr).build();
        return this.self();
    }

    public final B useTls() {
        return this.useTls(true);
    }

    public final B useTls(boolean useTls) {
        Preconditions.checkState((this.selectedProfile == null ? 1 : 0) != 0, (Object)"useTls() cannot be called once a profile is selected.");
        this.useTls = useTls;
        return this.self();
    }

    protected final boolean isUseTls() {
        return this.useTls;
    }

    public final B profileResources(String ... paths) {
        return this.profileResources((Iterable<String>)ImmutableList.copyOf((Object[])Objects.requireNonNull(paths, "paths")));
    }

    public final B profileResources(Iterable<String> paths) {
        ImmutableList newPaths = ImmutableList.copyOf(Objects.requireNonNull(paths, "paths"));
        Preconditions.checkArgument((!newPaths.isEmpty() ? 1 : 0) != 0, (Object)"paths is empty.");
        Preconditions.checkState((this.selectedProfile == null ? 1 : 0) != 0, (Object)"profileResources cannot be set after profile() is called.");
        this.profileResourcePaths = newPaths;
        return this.self();
    }

    public final B profile(String ... profiles) {
        Objects.requireNonNull(profiles, "profiles");
        return this.profile((Iterable<String>)ImmutableList.copyOf((Object[])profiles));
    }

    public final B profile(ClassLoader classLoader, String ... profiles) {
        Objects.requireNonNull(profiles, "profiles");
        return this.profile(classLoader, (Iterable<String>)ImmutableList.copyOf((Object[])profiles));
    }

    public final B profile(Iterable<String> profiles) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl != null) {
            this.profile(ccl, profiles);
        } else {
            this.profile(this.getClass().getClassLoader(), profiles);
        }
        return this.self();
    }

    public final B profile(ClassLoader classLoader, Iterable<String> profiles) {
        Objects.requireNonNull(classLoader, "classLoader");
        Objects.requireNonNull(profiles, "profiles");
        Preconditions.checkState((this.selectedProfile == null ? 1 : 0) != 0, (Object)"profile cannot be loaded more than once.");
        Preconditions.checkState((boolean)this.hosts.isEmpty(), (Object)"profile() and host() cannot be used together.");
        HashMap availableProfiles = new HashMap();
        try {
            List<URL> resourceUrls = this.findProfileResources(classLoader);
            Preconditions.checkState((!resourceUrls.isEmpty() ? 1 : 0) != 0, (String)"failed to find any of: ", this.profileResourcePaths);
            for (URL resourceUrl : resourceUrls) {
                List availableProfileList = (List)new ObjectMapper().readValue(resourceUrl, (TypeReference)new TypeReference<List<ClientProfile>>(){});
                availableProfileList.forEach(profile -> {
                    String name = profile.name();
                    ClientProfile existingProfile = (ClientProfile)availableProfiles.get(name);
                    if (existingProfile == null || existingProfile.priority() < profile.priority()) {
                        availableProfiles.put(name, profile);
                    }
                });
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException("failed to load: centraldogma-profiles.json", e2);
        }
        List<String> reversedProfiles = AbstractCentralDogmaBuilder.reverse(profiles);
        Preconditions.checkArgument((!reversedProfiles.isEmpty() ? 1 : 0) != 0, (Object)"profiles is empty.");
        for (String candidateName : reversedProfiles) {
            Preconditions.checkNotNull((Object)candidateName, (String)"profiles contains null: %s", profiles);
            ClientProfile candidate = (ClientProfile)availableProfiles.get(candidateName);
            if (candidate == null) continue;
            ImmutableSet.Builder newHostsBuilder = ImmutableSet.builder();
            candidate.hosts().stream().filter(e -> (this.useTls ? "https" : "http").equals(e.protocol())).forEach(e -> newHostsBuilder.add((Object)AbstractCentralDogmaBuilder.newEndpoint(e.host(), e.port())));
            ImmutableSet newHosts = newHostsBuilder.build();
            if (newHosts.isEmpty()) continue;
            this.selectedProfile = candidateName;
            this.hosts = newHosts;
            return this.self();
        }
        throw new IllegalArgumentException("no profile matches: " + profiles);
    }

    private List<URL> findProfileResources(ClassLoader classLoader) throws IOException {
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String p : this.profileResourcePaths) {
            Enumeration<URL> e = classLoader.getResources(p);
            while (e.hasMoreElements()) {
                urls.add((Object)e.nextElement());
            }
        }
        return urls.build();
    }

    private static List<String> reverse(Iterable<String> profiles) {
        ArrayList<String> reversedProfiles = new ArrayList<String>();
        Iterables.addAll(reversedProfiles, profiles);
        Collections.reverse(reversedProfiles);
        return reversedProfiles;
    }

    private static InetSocketAddress newEndpoint(String host, int port) {
        InetSocketAddress endpoint = InetAddresses.isInetAddress((String)host) ? new InetSocketAddress(InetAddresses.forString((String)host), port) : InetSocketAddress.createUnresolved(host, port);
        return endpoint;
    }

    @Nullable
    protected final String selectedProfile() {
        return this.selectedProfile;
    }

    protected final Set<InetSocketAddress> hosts() {
        return this.hosts;
    }

    public final B accessToken(String accessToken) {
        Objects.requireNonNull(accessToken, "accessToken");
        Preconditions.checkArgument((!accessToken.isEmpty() ? 1 : 0) != 0, (Object)"accessToken is empty.");
        this.accessToken = accessToken;
        return this.self();
    }

    protected String accessToken() {
        return this.accessToken;
    }
}

