/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.spring;

import com.linecorp.centraldogma.internal.shaded.guava.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.PositiveOrZero;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="centraldogma")
@Validated
public class CentralDogmaSettings {
    @Nullable
    private String profile;
    @Nullable
    private List<String> hosts;
    @Nullable
    private String accessToken;
    @Nullable
    private Long healthCheckIntervalMillis;
    @Nullable
    private Boolean useTls;
    @Nullable
    private Integer maxNumRetriesOnReplicationLag;
    @Nullable
    private Long retryIntervalOnReplicationLagMillis;
    @Nullable
    private Long initializationTimeoutMillis;

    @Nullable
    public String getProfile() {
        return this.profile;
    }

    public void setProfile(@NotBlank String profile) {
        this.profile = profile;
    }

    @Nullable
    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(@NotEmpty List<String> hosts) {
        this.hosts = new ArrayList<String>(hosts);
    }

    @Nullable
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(@NotBlank String accessToken) {
        this.accessToken = accessToken;
    }

    @Nullable
    public Long getHealthCheckIntervalMillis() {
        return this.healthCheckIntervalMillis;
    }

    public void setHealthCheckIntervalMillis(@PositiveOrZero long healthCheckIntervalMillis) {
        this.healthCheckIntervalMillis = healthCheckIntervalMillis;
    }

    @Nullable
    public Boolean getUseTls() {
        return this.useTls;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    @Nullable
    public Integer getMaxNumRetriesOnReplicationLag() {
        return this.maxNumRetriesOnReplicationLag;
    }

    public void setMaxNumRetriesOnReplicationLag(@Nullable Integer maxNumRetriesOnReplicationLag) {
        this.maxNumRetriesOnReplicationLag = maxNumRetriesOnReplicationLag;
    }

    @Nullable
    public Long getRetryIntervalOnReplicationLagMillis() {
        return this.retryIntervalOnReplicationLagMillis;
    }

    public void setRetryIntervalOnReplicationLagMillis(@Nullable Long retryIntervalOnReplicationLagMillis) {
        this.retryIntervalOnReplicationLagMillis = retryIntervalOnReplicationLagMillis;
    }

    @Nullable
    public Long initializationTimeoutMillis() {
        return this.initializationTimeoutMillis;
    }

    public void setInitializationTimeoutMillis(@Nullable Long initializationTimeoutMillis) {
        this.initializationTimeoutMillis = initializationTimeoutMillis;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("profile", (Object)this.profile).add("hosts", this.hosts).add("accessToken", (Object)(this.accessToken != null ? "********" : null)).add("healthCheckIntervalMillis", (Object)this.healthCheckIntervalMillis).add("initializationTimeoutMillis", (Object)this.initializationTimeoutMillis).add("useTls", (Object)this.useTls).add("maxNumRetriesOnReplicationLag", (Object)this.maxNumRetriesOnReplicationLag).add("retryIntervalOnReplicationLagMillis", (Object)this.retryIntervalOnReplicationLagMillis).toString();
    }
}

