/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.centraldogma.client.spring;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.centraldogma.client.CentralDogma;
import com.linecorp.centraldogma.client.armeria.ArmeriaCentralDogmaBuilder;
import com.linecorp.centraldogma.client.armeria.ArmeriaClientConfigurator;
import com.linecorp.centraldogma.client.armeria.DnsAddressEndpointGroupConfigurator;
import com.linecorp.centraldogma.client.spring.CentralDogmaClientFactoryConfigurator;
import com.linecorp.centraldogma.client.spring.CentralDogmaSettings;
import com.linecorp.centraldogma.internal.shaded.guava.net.HostAndPort;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnMissingBean(value={CentralDogma.class})
@EnableConfigurationProperties(value={CentralDogmaSettings.class})
public class CentralDogmaClientAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CentralDogmaClientAutoConfiguration.class);
    static final long DEFAULT_INITIALIZATION_TIMEOUT_MILLIS = 15000L;

    @Bean
    public CentralDogma dogmaClient(Environment env, CentralDogmaSettings settings, Optional<List<CentralDogmaClientFactoryConfigurator>> factoryConfigurators, Optional<ArmeriaClientConfigurator> armeriaClientConfigurator, Optional<DnsAddressEndpointGroupConfigurator> dnsAddressEndpointGroupConfigurator, Optional<MeterRegistry> meterRegistry) throws UnknownHostException {
        Long retryIntervalOnReplicationLagMillis;
        String accessToken;
        Boolean useTls;
        ArmeriaCentralDogmaBuilder builder = new ArmeriaCentralDogmaBuilder();
        if (factoryConfigurators.isPresent()) {
            ClientFactoryBuilder clientFactoryBuilder = ClientFactory.builder();
            factoryConfigurators.get().forEach(configurator -> configurator.configure(clientFactoryBuilder));
            builder.clientFactory(clientFactoryBuilder.build());
        }
        builder.clientConfigurator(cb -> armeriaClientConfigurator.ifPresent(configurator -> configurator.configure(cb)));
        dnsAddressEndpointGroupConfigurator.ifPresent(arg_0 -> ((ArmeriaCentralDogmaBuilder)builder).dnsAddressEndpointGroupConfigurator(arg_0));
        Long healthCheckIntervalMillis = settings.getHealthCheckIntervalMillis();
        if (healthCheckIntervalMillis != null) {
            builder.healthCheckIntervalMillis(healthCheckIntervalMillis.longValue());
        }
        if ((useTls = settings.getUseTls()) != null) {
            builder.useTls(useTls.booleanValue());
        }
        if ((accessToken = settings.getAccessToken()) != null) {
            builder.accessToken(accessToken);
        }
        String profile = settings.getProfile();
        List<String> hosts = settings.getHosts();
        if (profile != null) {
            if (hosts != null) {
                throw new IllegalStateException("'hosts' and 'profile' are mutually exclusive. Do not set both of them.");
            }
            builder.profile(CentralDogmaClientAutoConfiguration.class.getClassLoader(), new String[]{profile});
        } else if (hosts != null) {
            for (String h : hosts) {
                HostAndPort hostAndPort = HostAndPort.fromString((String)h);
                if (hostAndPort.hasPort()) {
                    builder.host(hostAndPort.getHost(), hostAndPort.getPort());
                    continue;
                }
                builder.host(hostAndPort.getHost());
            }
        } else {
            Object[] springBootProfiles = env.getActiveProfiles();
            logger.info("Using the Spring Boot profiles as the source of the Central Dogma client profile: {}", springBootProfiles);
            builder.profile((String[])springBootProfiles);
        }
        Integer maxNumRetriesOnReplicationLag = settings.getMaxNumRetriesOnReplicationLag();
        if (maxNumRetriesOnReplicationLag != null) {
            builder.maxNumRetriesOnReplicationLag(maxNumRetriesOnReplicationLag.intValue());
        }
        if ((retryIntervalOnReplicationLagMillis = settings.getRetryIntervalOnReplicationLagMillis()) != null) {
            builder.retryIntervalOnReplicationLagMillis(retryIntervalOnReplicationLagMillis.longValue());
        }
        meterRegistry.ifPresent(arg_0 -> ((ArmeriaCentralDogmaBuilder)builder).meterRegistry(arg_0));
        CentralDogma centralDogma = builder.build();
        Long initializationTimeoutMillis = settings.getInitializationTimeoutMillis();
        if (initializationTimeoutMillis == null) {
            initializationTimeoutMillis = 15000L;
        }
        if (initializationTimeoutMillis > 0L) {
            try {
                centralDogma.whenEndpointReady().get(initializationTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Failed to initialize the endpoints of " + String.valueOf(centralDogma) + " in " + initializationTimeoutMillis + " milliseconds", e);
            }
        }
        return centralDogma;
    }
}

