/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.linecorp.bot.client.ChannelManagementClientRetrofitIface;
import com.linecorp.bot.client.ChannelManagementSyncClient;
import com.linecorp.bot.client.ChannelManagementSyncClientImpl;
import com.linecorp.bot.client.ChannelTokenSupplier;
import com.linecorp.bot.client.LineClientConstants;
import com.linecorp.bot.client.LineMessagingClientBuilder;
import java.net.URI;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public class ChannelManagementClientBuilder {
    private URI apiEndPoint = LineClientConstants.DEFAULT_API_END_POINT;
    private ChannelTokenSupplier channelTokenSupplier;

    public static ChannelManagementClientBuilder create(@NonNull ChannelTokenSupplier channelTokenSupplier) {
        if (channelTokenSupplier == null) {
            throw new NullPointerException("channelTokenSupplier is marked non-null but is null");
        }
        return new ChannelManagementClientBuilder().channelTokenSupplier(channelTokenSupplier);
    }

    public ChannelManagementSyncClient build() {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.addInterceptor((Interceptor)LineMessagingClientBuilder.buildAuthenticationInterceptor(this.channelTokenSupplier)).addInterceptor(LineMessagingClientBuilder.buildLoggingInterceptor());
        OkHttpClient okHttpClient = okHttpClientBuilder.build();
        Retrofit.Builder retrofitBuilder = LineMessagingClientBuilder.createDefaultRetrofitBuilder();
        retrofitBuilder.client(okHttpClient);
        retrofitBuilder.baseUrl(this.apiEndPoint.toString());
        Retrofit retrofit = retrofitBuilder.build();
        ChannelManagementClientRetrofitIface retrofitIface = (ChannelManagementClientRetrofitIface)retrofit.create(ChannelManagementClientRetrofitIface.class);
        return ChannelManagementSyncClientImpl.of(retrofitIface);
    }

    @Generated
    public ChannelManagementClientBuilder apiEndPoint(URI apiEndPoint) {
        this.apiEndPoint = apiEndPoint;
        return this;
    }

    @Generated
    public ChannelManagementClientBuilder channelTokenSupplier(ChannelTokenSupplier channelTokenSupplier) {
        this.channelTokenSupplier = channelTokenSupplier;
        return this;
    }
}

