/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.rxjava2;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.rxjava2.RequestContextConditionalSubscriber;
import com.linecorp.armeria.common.rxjava2.RequestContextSubscriber;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.reactivex.disposables.Disposable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import org.reactivestreams.Subscriber;

final class RequestContextConnectableFlowable<T>
extends ConnectableFlowable<T> {
    private final ConnectableFlowable<T> source;
    private final RequestContext assemblyContext;

    RequestContextConnectableFlowable(ConnectableFlowable<T> source, RequestContext assemblyContext) {
        this.source = source;
        this.assemblyContext = assemblyContext;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            if (s instanceof ConditionalSubscriber) {
                this.source.subscribe(new RequestContextConditionalSubscriber((ConditionalSubscriber)s, this.assemblyContext));
            } else {
                this.source.subscribe(new RequestContextSubscriber<T>(s, this.assemblyContext));
            }
        }
    }

    public void connect(Consumer<? super Disposable> connection) {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.source.connect(connection);
        }
    }
}

