/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.rxjava2;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunctionProvider;
import com.linecorp.armeria.server.rxjava2.ObservableResponseConverterFunction;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class ObservableResponseConverterFunctionProvider
implements ResponseConverterFunctionProvider {
    @Nullable
    public ResponseConverterFunction createResponseConverterFunction(Type returnType, ResponseConverterFunction responseConverter) {
        Class clazz = ClassUtil.typeToClass((Type)returnType);
        if (clazz != null && ObservableResponseConverterFunctionProvider.isSupportedClass(clazz)) {
            ObservableResponseConverterFunctionProvider.ensureNoMoreObservableSource(returnType, returnType);
            return new ObservableResponseConverterFunction(responseConverter);
        }
        return null;
    }

    private static void ensureNoMoreObservableSource(Type returnType, Type type) {
        if (type instanceof ParameterizedType) {
            Type[] args;
            for (Type arg : args = ((ParameterizedType)type).getActualTypeArguments()) {
                Class clazz = ClassUtil.typeToClass((Type)arg);
                if (clazz != null && ObservableResponseConverterFunctionProvider.isSupportedClass(clazz)) {
                    throw new IllegalStateException("Disallowed type exists in the generic type arguments of the return type '" + returnType + "': " + clazz.getName());
                }
                ObservableResponseConverterFunctionProvider.ensureNoMoreObservableSource(returnType, arg);
            }
        }
    }

    private static boolean isSupportedClass(Class<?> clazz) {
        return Observable.class.isAssignableFrom(clazz) || Maybe.class.isAssignableFrom(clazz) || Single.class.isAssignableFrom(clazz) || Completable.class.isAssignableFrom(clazz);
    }

    public String toString() {
        return ObservableResponseConverterFunctionProvider.class.getSimpleName();
    }
}

