/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.graphql.protocol.GraphqlRequest;
import com.linecorp.armeria.common.multipart.MultipartFile;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.server.FileAggregatedMultipart;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.protocol.MultipartVariableMapper;
import io.netty.util.concurrent.EventExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;

@UnstableApi
public abstract class AbstractGraphqlService
extends AbstractHttpService {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> JSON_MAP = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<Map<String, List<String>>> MAP_PARAM = new TypeReference<Map<String, List<String>>>(){};

    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Map<String, Object> extensions;
        Map<String, Object> variables;
        QueryParams queryString = QueryParams.fromQueryString((String)ctx.query());
        String query = queryString.get("query");
        if (Strings.isNullOrEmpty((String)query)) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"query is missing");
        }
        if ((query = query.trim()).startsWith("mutation")) {
            return HttpResponse.of((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED, (MediaType)MediaType.PLAIN_TEXT, (String)"Mutation is not allowed");
        }
        String operationName = queryString.get("operationName");
        try {
            variables = AbstractGraphqlService.toMap(queryString.get("variables"));
            extensions = AbstractGraphqlService.toMap(queryString.get("extensions"));
        }
        catch (JsonProcessingException ex) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)("Failed to parse a GraphQL query: " + ctx.query()));
        }
        return this.executeGraphql(ctx, GraphqlRequest.of(query, operationName, variables, extensions));
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest request) throws Exception {
        MediaType contentType = request.contentType();
        if (contentType == null) {
            return AbstractGraphqlService.unsupportedMediaType();
        }
        if (contentType.is(MediaType.MULTIPART_FORM_DATA)) {
            return HttpResponse.of((CompletionStage)FileAggregatedMultipart.aggregateMultipart((ServiceRequestContext)ctx, (HttpRequest)request).thenApply(multipart -> {
                try {
                    ListMultimap multipartParams = multipart.params();
                    String operationsParam = AbstractGraphqlService.getValueFromMultipartParam("operations", (ListMultimap<String, String>)multipartParams);
                    String mapParam = AbstractGraphqlService.getValueFromMultipartParam("map", (ListMultimap<String, String>)multipartParams);
                    Map<String, Object> operations = AbstractGraphqlService.parseJsonString(operationsParam, JSON_MAP);
                    Map<String, List<String>> map = AbstractGraphqlService.parseJsonString(mapParam, MAP_PARAM);
                    String query = AbstractGraphqlService.toStringFromJson("query", operations.get("query"));
                    if (Strings.isNullOrEmpty((String)query)) {
                        return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)("query is missing: " + operationsParam));
                    }
                    Map<String, Object> variables = AbstractGraphqlService.toMapFromJson(operations.get("variables"));
                    HashMap<String, Object> copiedVariables = new HashMap<String, Object>(variables);
                    Map<String, Object> extensions = AbstractGraphqlService.toMapFromJson(operations.get("extensions"));
                    for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                        List multipartFiles = multipart.files().get((Object)entry.getKey());
                        AbstractGraphqlService.bindMultipartVariable(copiedVariables, entry.getValue(), multipartFiles);
                    }
                    return this.executeGraphql(ctx, GraphqlRequest.of(query, null, copiedVariables, extensions));
                }
                catch (JsonProcessingException ex) {
                    return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)("Failed to parse a JSON document: " + ex.getMessage()));
                }
                catch (IllegalArgumentException ex) {
                    return AbstractGraphqlService.createResponse(ex);
                }
                catch (Exception ex) {
                    return HttpResponse.ofFailure((Throwable)ex);
                }
            }));
        }
        if (contentType.isJson()) {
            return HttpResponse.of((CompletionStage)request.aggregate((EventExecutor)ctx.eventLoop()).thenApply(req -> {
                try (SafeCloseable ignored = ctx.push();){
                    String body = req.contentUtf8();
                    if (Strings.isNullOrEmpty((String)body)) {
                        HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"Missing request body");
                        return httpResponse;
                    }
                    Map<String, Object> requestMap = AbstractGraphqlService.parseJsonString(body, JSON_MAP);
                    String query = AbstractGraphqlService.toStringFromJson("query", requestMap.get("query"));
                    if (Strings.isNullOrEmpty((String)query)) {
                        HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"query is missing");
                        return httpResponse;
                    }
                    String operationName = AbstractGraphqlService.toStringFromJson("operationName", requestMap.get("operationName"));
                    Map<String, Object> variables = AbstractGraphqlService.toMapFromJson(requestMap.get("variables"));
                    Map<String, Object> extensions = AbstractGraphqlService.toMapFromJson(requestMap.get("extensions"));
                    HttpResponse httpResponse = this.executeGraphql(ctx, GraphqlRequest.of(query, operationName, variables, extensions));
                    return httpResponse;
                }
            }));
        }
        if (contentType.is(MediaType.GRAPHQL)) {
            return HttpResponse.of((CompletionStage)request.aggregate((EventExecutor)ctx.eventLoop()).thenApply(req -> {
                try (SafeCloseable ignored = ctx.push();){
                    String query = req.contentUtf8();
                    if (Strings.isNullOrEmpty((String)query)) {
                        HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"query is missing");
                        return httpResponse;
                    }
                    HttpResponse httpResponse = this.executeGraphql(ctx, GraphqlRequest.of(query));
                    return httpResponse;
                }
            }));
        }
        return AbstractGraphqlService.unsupportedMediaType();
    }

    private static void bindMultipartVariable(Map<String, Object> variables, List<String> operationsPaths, @Nullable List<MultipartFile> multipartFiles) {
        if (multipartFiles == null || multipartFiles.isEmpty()) {
            return;
        }
        MultipartFile multipartFile = multipartFiles.get(0);
        for (String objectPath : operationsPaths) {
            MultipartVariableMapper.mapVariable(objectPath, variables, multipartFile);
        }
    }

    public ExchangeType exchangeType(RoutingContext routingContext) {
        MediaType contentType = routingContext.contentType();
        if (contentType != null && contentType.is(MediaType.MULTIPART_FORM_DATA)) {
            return ExchangeType.REQUEST_STREAMING;
        }
        return ExchangeType.UNARY;
    }

    protected abstract HttpResponse executeGraphql(ServiceRequestContext var1, GraphqlRequest var2) throws Exception;

    private static Map<String, Object> toMap(@Nullable String value) throws JsonProcessingException {
        if (Strings.isNullOrEmpty((String)value)) {
            return ImmutableMap.of();
        }
        return AbstractGraphqlService.parseJsonString(value, JSON_MAP);
    }

    private static String getValueFromMultipartParam(String name, ListMultimap<String, String> params) {
        List list = params.get((Object)name);
        if (list.size() > 1) {
            throw new IllegalArgumentException("More than one '" + name + "' received.");
        }
        if (list.isEmpty() || Strings.isNullOrEmpty((String)((String)list.get(0)))) {
            throw new IllegalArgumentException('\'' + name + "' form field is missing");
        }
        return (String)list.get(0);
    }

    @Nullable
    private static String toStringFromJson(String name, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Invalid " + name + " (expected: string)");
    }

    private static Map<String, Object> toMapFromJson(@Nullable Object maybeMap) {
        if (maybeMap == null) {
            return ImmutableMap.of();
        }
        if (maybeMap instanceof Map) {
            Map map = (Map)maybeMap;
            if (map.isEmpty()) {
                return ImmutableMap.of();
            }
            return Collections.unmodifiableMap((Map)maybeMap);
        }
        throw new IllegalArgumentException("Unknown parameter type variables");
    }

    private static <T> T parseJsonString(String content, TypeReference<T> typeReference) throws JsonProcessingException {
        return (T)mapper.readValue(content, typeReference);
    }

    private static HttpResponse unsupportedMediaType() {
        return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT, (String)"Unsupported media type. Only JSON compatible types and application/graphql are supported.");
    }

    private static HttpResponse createResponse(IllegalArgumentException ex) {
        String message = ex.getMessage() == null ? HttpStatus.BAD_REQUEST.reasonPhrase() : ex.getMessage();
        return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)message);
    }
}

