/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.graphql.protocol;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import java.util.List;

public final class GraphqlUtil {
    @Nullable
    public static MediaType produceType(RequestHeaders headers) {
        MediaType contentType = headers.contentType();
        if (HttpMethod.POST == headers.method() && contentType != null && (contentType.is(MediaType.GRAPHQL) || contentType.is(MediaType.MULTIPART_FORM_DATA))) {
            return MediaType.GRAPHQL_JSON;
        }
        List acceptTypes = headers.accept();
        if (acceptTypes.isEmpty()) {
            return MediaType.GRAPHQL_JSON;
        }
        for (MediaType accept : acceptTypes) {
            if (MediaType.ANY_TYPE.is(accept) || MediaType.ANY_APPLICATION_TYPE.is(accept)) {
                return MediaType.GRAPHQL_JSON;
            }
            if (!accept.is(MediaType.GRAPHQL_JSON) && !accept.is(MediaType.JSON)) continue;
            return accept;
        }
        return null;
    }

    private GraphqlUtil() {
    }
}

