/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.graphql.protocol.GraphqlRequest;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.util.concurrent.EventExecutor;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public abstract class AbstractGraphqlService
extends AbstractHttpService {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> JSON_MAP = new TypeReference<Map<String, Object>>(){};

    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Map<String, Object> extensions;
        Map<String, Object> variables;
        QueryParams queryString = QueryParams.fromQueryString((String)ctx.query());
        String query = queryString.get("query");
        if (Strings.isNullOrEmpty((String)query)) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"Missing query");
        }
        if ((query = query.trim()).startsWith("mutation")) {
            return HttpResponse.of((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED, (MediaType)MediaType.PLAIN_TEXT, (String)"Mutation is not allowed");
        }
        String operationName = queryString.get("operationName");
        try {
            variables = AbstractGraphqlService.toMap(queryString.get("variables"));
            extensions = AbstractGraphqlService.toMap(queryString.get("extensions"));
        }
        catch (JsonProcessingException ex) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)("Failed to parse a GraphQL query: " + ctx.query()));
        }
        return this.executeGraphql(ctx, GraphqlRequest.of(query, operationName, variables, extensions));
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest request) throws Exception {
        MediaType contentType = request.contentType();
        if (contentType == null) {
            return AbstractGraphqlService.unsupportedMediaType();
        }
        if (contentType.isJson()) {
            return HttpResponse.from((CompletionStage)request.aggregate((EventExecutor)ctx.eventLoop()).thenApply(req -> {
                try (SafeCloseable ignored = ctx.push();){
                    String body = req.contentUtf8();
                    if (Strings.isNullOrEmpty((String)body)) {
                        HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"Missing request body");
                        return httpResponse;
                    }
                    Map<String, Object> requestMap = AbstractGraphqlService.parseJsonString(body);
                    String query = AbstractGraphqlService.toStringFromJson("query", requestMap.get("query"));
                    if (Strings.isNullOrEmpty((String)query)) {
                        HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"Missing query");
                        return httpResponse;
                    }
                    String operationName = AbstractGraphqlService.toStringFromJson("operationName", requestMap.get("operationName"));
                    Map<String, Object> variables = AbstractGraphqlService.toMapFromJson(requestMap.get("variables"));
                    Map<String, Object> extensions = AbstractGraphqlService.toMapFromJson(requestMap.get("extensions"));
                    HttpResponse httpResponse = this.executeGraphql(ctx, GraphqlRequest.of(query, operationName, variables, extensions));
                    return httpResponse;
                }
            }));
        }
        if (contentType.is(MediaType.GRAPHQL)) {
            return HttpResponse.from((CompletionStage)request.aggregate((EventExecutor)ctx.eventLoop()).thenApply(req -> {
                try (SafeCloseable ignored = ctx.push();){
                    String query = req.contentUtf8();
                    if (Strings.isNullOrEmpty((String)query)) {
                        HttpResponse httpResponse = HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT, (String)"Missing query");
                        return httpResponse;
                    }
                    HttpResponse httpResponse = this.executeGraphql(ctx, GraphqlRequest.of(query));
                    return httpResponse;
                }
            }));
        }
        return AbstractGraphqlService.unsupportedMediaType();
    }

    public ExchangeType exchangeType(RequestHeaders headers, Route route) {
        return ExchangeType.UNARY;
    }

    protected abstract HttpResponse executeGraphql(ServiceRequestContext var1, GraphqlRequest var2) throws Exception;

    private static Map<String, Object> toMap(@Nullable String value) throws JsonProcessingException {
        if (Strings.isNullOrEmpty((String)value)) {
            return ImmutableMap.of();
        }
        return AbstractGraphqlService.parseJsonString(value);
    }

    @Nullable
    private static String toStringFromJson(String name, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("Invalid " + name + " (expected: string)");
    }

    private static Map<String, Object> toMapFromJson(@Nullable Object maybeMap) {
        if (maybeMap == null) {
            return ImmutableMap.of();
        }
        if (maybeMap instanceof Map) {
            Map map = (Map)maybeMap;
            if (map.isEmpty()) {
                return ImmutableMap.of();
            }
            return map;
        }
        throw new IllegalArgumentException("Unknown parameter type variables");
    }

    private static Map<String, Object> parseJsonString(String content) throws JsonProcessingException {
        return (Map)mapper.readValue(content, JSON_MAP);
    }

    private static HttpResponse unsupportedMediaType() {
        return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT, (String)"Unsupported media type. Only JSON compatible types and application/graphql are supported.");
    }
}

